/*
 * Decompiled with CFR 0.152.
 */
package ste.web.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import ste.web.security.CertificateBuilder;

public class KeystoreCLI {
    public static final String COMMAND_HELP = "help";
    public static final String COMMAND_INIT = "init";
    public static final String OPTION_KEYSTORE = "keystore";
    public static final String OPTION_PASSWORD = "password";
    private static final OptionParser parser = new OptionParser();

    public static void main(String[] args) throws Exception {
        System.out.println("welcome to keystore command line tool\n");
        if (args.length == 0) {
            KeystoreCLI.usage();
            return;
        }
        if (COMMAND_HELP.equalsIgnoreCase(args[0])) {
            KeystoreCLI.usage();
            System.out.println();
            return;
        }
        if (COMMAND_INIT.equalsIgnoreCase(args[0])) {
            OptionSet options = null;
            try {
                String[] notCommandArgs = new String[args.length - 1];
                System.arraycopy(args, 1, notCommandArgs, 0, notCommandArgs.length);
                options = parser.parse(notCommandArgs);
                File keystoreFile = new File((String)options.valueOf(OPTION_KEYSTORE)).getAbsoluteFile();
                if (keystoreFile.exists()) {
                    System.out.println("keystore " + keystoreFile.getAbsolutePath() + " already exists");
                    System.out.println("do you want to overwrite it (y/N)?");
                    if (System.in.read() != 121 || System.in.read() != 10) {
                        System.out.println("keystore not initialized");
                        return;
                    }
                }
                try (FileOutputStream os = new FileOutputStream(keystoreFile);){
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(null, null);
                    CertificateBuilder builder = new CertificateBuilder("cn=localhost");
                    X509Certificate certificate = builder.build();
                    String password = (String)options.valueOf(OPTION_PASSWORD);
                    ks.setKeyEntry("ste.https", builder.getKeyPair().getPrivate(), password.toCharArray(), new Certificate[]{certificate});
                    ks.store(os, password.toCharArray());
                    System.out.println(String.format("keystore %s initialized with %s", keystoreFile.getAbsolutePath(), "".equals(options.valueOf(OPTION_PASSWORD)) ? "no password" : "password " + password));
                }
            }
            catch (OptionException x) {
                System.out.println("ups! " + x.getMessage().toLowerCase());
                KeystoreCLI.usage();
            }
            return;
        }
        System.out.println("ups! invalid command " + args[0]);
        KeystoreCLI.usage();
    }

    public static void usage() {
        System.out.println("usage:\n  " + KeystoreCLI.class.getName() + " commands options\n");
        System.out.println("Command  Description\n-------  -----------\n");
        System.out.println("help     show keystore command line tool usage");
        System.out.println("init     initialize a new keystore with a new keypair");
        System.out.println("");
        try {
            parser.printHelpOn((OutputStream)System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        parser.accepts(OPTION_KEYSTORE, "keystore pathname").withRequiredArg().defaultsTo((Object)OPTION_KEYSTORE, (Object[])new String[0]).describedAs("pathname");
        parser.accepts(OPTION_PASSWORD, "keystore password").withRequiredArg().defaultsTo((Object)"", (Object[])new String[0]).describedAs("string");
    }
}

