/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.function.Consumer;

public class NumericSeries {
    protected int from;
    protected Integer to;
    protected int step = 1;

    public NumericSeries from(int from) {
        this.from = from;
        return this;
    }

    public NumericSeries to(int to) {
        this.to = to;
        return this;
    }

    public NumericSeries step(int step) {
        this.step = step;
        return this;
    }

    public void loop(Consumer<Integer> consumer) {
        if (this.to == null) {
            throw new IllegalStateException("'to' has not been set");
        }
        if (this.from == this.to) {
            return;
        }
        if (this.step == 0) {
            return;
        }
        int start = this.from;
        int end = this.to;
        if (this.step < 0) {
            start = this.to;
            end = this.from;
        }
        boolean isForward = end >= start;
        int increment = isForward ? Math.abs(this.step) : -Math.abs(this.step);
        for (int i = start; isForward && i <= end || !isForward && i >= end; i += increment) {
            consumer.accept(i);
        }
    }
}

