/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import ste.lloop.NumericSeries;

public class Sequence<T> {
    private final T[] array;
    private final NumericSeries indexes;

    Sequence(T[] array) {
        this.array = array;
        this.indexes = new NumericSeries();
    }

    public Sequence<T> step(int step) {
        this.indexes.step(step);
        return this;
    }

    public Sequence<T> from(int from) {
        if (from < 0) {
            throw new IndexOutOfBoundsException("The 'from' value cannot be less than zero.");
        }
        this.indexes.from(from);
        return this;
    }

    public Sequence<T> to(int to) {
        this.indexes.to(to);
        return this;
    }

    public void loop(BiConsumer<Integer, T> consumer) {
        if (this.array == null || this.array.length == 0) {
            return;
        }
        if (this.indexes.to == null) {
            this.indexes.to = this.array.length - 1;
        } else if (this.indexes.to > this.array.length - 1) {
            this.indexes.to = this.array.length - 1;
        }
        this.indexes.loop((Integer i) -> consumer.accept((Integer)i, this.array[i]));
    }

    public void loop(Consumer<T> consumer) {
        this.loop((Integer index, T element) -> consumer.accept(element));
    }
}

