/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import ste.lloop.CollectionSequence;
import ste.lloop.Loop;

class ForwardOnlySequence<T>
extends CollectionSequence<ForwardOnlySequence<T>> {
    private final Iterable<T> iterable;

    ForwardOnlySequence(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public ForwardOnlySequence<T> step(int step) {
        if (step < 0) {
            throw new IllegalArgumentException("step can not be negative for forward-only collections");
        }
        return (ForwardOnlySequence)super.step(step);
    }

    @Override
    public ForwardOnlySequence<T> from(int from) {
        if (this.indexes.to != null && from > this.indexes.to) {
            throw new IllegalArgumentException("from can not be greater than to in a forward-only sequence");
        }
        return (ForwardOnlySequence)super.from(from);
    }

    @Override
    public ForwardOnlySequence<T> to(int to) {
        super.to(to);
        if (to < this.indexes.from) {
            throw new IllegalArgumentException("from can not be greater than to in a forward-only sequence");
        }
        return this;
    }

    public <R> R loop(BiConsumer<Integer, T> consumer) {
        if (this.iterable == null) {
            return null;
        }
        if (this.indexes.step == 0) {
            return null;
        }
        Iterator iterator = this.iterable.iterator();
        AtomicInteger currentIndex = new AtomicInteger(0);
        return this.indexes.loop((Integer targetIndex) -> {
            Object element = null;
            while (currentIndex.get() <= targetIndex) {
                if (!iterator.hasNext()) {
                    Loop._break_(targetIndex);
                }
                element = iterator.next();
                currentIndex.incrementAndGet();
            }
            consumer.accept((Integer)targetIndex, (Object)element);
        });
    }
}

