/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import ste.lloop.CollectionSequence;
import ste.lloop.MapLoopConsumer;

class MapSequence<K, V>
extends CollectionSequence<MapSequence<K, V>> {
    private final Map<K, V> map;

    MapSequence(Map<K, V> map) {
        this.map = map;
    }

    public <R> R loop(MapLoopConsumer<K, V> consumer) {
        if (this.map == null || this.map.isEmpty()) {
            return null;
        }
        ArrayList entries = new ArrayList(this.map.entrySet());
        int size = entries.size();
        if (this.indexes.to == null) {
            this.indexes.to(size - 1);
        }
        if (this.indexes.to >= size) {
            this.indexes.to(size - 1);
        }
        return this.indexes.loop((Integer index) -> {
            Map.Entry entry = (Map.Entry)entries.get((int)index);
            consumer.accept((Integer)index, entry.getKey(), entry.getValue());
        });
    }

    public <R> R loop(BiConsumer<K, V> consumer) {
        return this.loop((Integer index, K key, V value) -> consumer.accept(key, value));
    }
}

