/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.function.Consumer;
import ste.lloop.ReturnValue;

public class NumericSequence {
    protected int from;
    protected Integer to;
    protected int step = 1;

    public NumericSequence from(int from) {
        this.from = from;
        return this;
    }

    public NumericSequence to(int to) {
        if (this.step < 0) {
            throw new IllegalArgumentException("a negative step is not allowed when to is set");
        }
        this.to = to;
        return this;
    }

    public NumericSequence step(int step) {
        if (this.to != null && step < 0) {
            throw new IllegalArgumentException("a negative step is not allowed when to is set");
        }
        this.step = step;
        return this;
    }

    public <R> R loop(Consumer<Integer> consumer) {
        block7: {
            if (this.step == 0) {
                return null;
            }
            try {
                if (this.to != null) {
                    if (this.from == this.to) {
                        return null;
                    }
                    boolean isForward = this.from <= this.to;
                    int actualStep = Math.abs(this.step);
                    int increment = isForward ? actualStep : -actualStep;
                    for (int i = this.from; isForward && i <= this.to || !isForward && i >= this.to; i += increment) {
                        consumer.accept(i);
                    }
                    break block7;
                }
                int increment = this.step;
                int i = this.from;
                while (true) {
                    consumer.accept(i);
                    i += increment;
                }
            }
            catch (ReturnValue e) {
                return e.value();
            }
        }
        return null;
    }
}

