/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import ste.lloop.AbstractSequence;
import ste.lloop.Loop;

public class ForwardOnlySequence<T>
extends AbstractSequence<ForwardOnlySequence<T>> {
    private final Iterable<T> iterable;

    public ForwardOnlySequence(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public ForwardOnlySequence<T> to(int to) {
        if (to < this.indexes.from) {
            throw new IllegalArgumentException("to can not be negative or smaller than from for forward-only sequences");
        }
        return (ForwardOnlySequence)super.to(to);
    }

    @Override
    public ForwardOnlySequence<T> from(int from) {
        if (from < 0 || this.indexes.to != null && from > this.indexes.to) {
            throw new IllegalArgumentException("from can not be negative or greater than to for forward-only sequences");
        }
        return (ForwardOnlySequence)super.from(from);
    }

    @Override
    public ForwardOnlySequence<T> step(int step) {
        if (step < 0) {
            throw new IllegalArgumentException("step can never be negative for forward-only sequences");
        }
        return (ForwardOnlySequence)super.step(step);
    }

    public <R> R loop(BiConsumer<Integer, T> consumer) {
        if (this.iterable == null) {
            return null;
        }
        if (this.indexes.step == 0) {
            return null;
        }
        Iterator iterator = this.iterable.iterator();
        AtomicInteger currentIndex = new AtomicInteger(0);
        return this.indexes.loop((Integer targetIndex) -> {
            Object element = null;
            while (currentIndex.get() <= targetIndex) {
                if (!iterator.hasNext()) {
                    Loop._break_(targetIndex);
                }
                element = iterator.next();
                currentIndex.incrementAndGet();
            }
            consumer.accept((Integer)targetIndex, (Object)element);
        });
    }
}

