/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import ste.lloop.ForwardOnlySequence;
import ste.lloop.Loop;

public class EnumerationSequence<T>
extends ForwardOnlySequence<T> {
    private final Enumeration<T> enumeration;

    public EnumerationSequence(Enumeration<T> enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public <R> R loop(BiConsumer<Integer, T> consumer) {
        if (this.enumeration == null) {
            return null;
        }
        if (this.indexes.step == 0) {
            return null;
        }
        AtomicInteger currentIndex = new AtomicInteger(0);
        return this.indexes.loop((Integer targetIndex) -> {
            Object element = null;
            while (currentIndex.get() <= targetIndex) {
                if (!this.enumeration.hasMoreElements()) {
                    Loop._break_(targetIndex);
                }
                element = this.enumeration.nextElement();
                currentIndex.incrementAndGet();
            }
            consumer.accept((Integer)targetIndex, (T)element);
        });
    }
}

