/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import ste.lloop.AbstractSequence;

public abstract class ForwardOnlySequence<T>
extends AbstractSequence<ForwardOnlySequence<T>, T> {
    protected ForwardOnlySequence() {
    }

    @Override
    public ForwardOnlySequence<T> to(int to) {
        if (to < this.indexes.from) {
            throw new IllegalArgumentException("to can not be negative or smaller than from for forward-only sequences");
        }
        return (ForwardOnlySequence)super.to(to);
    }

    @Override
    public ForwardOnlySequence<T> from(int from) {
        if (from < 0 || this.indexes.to != null && from > this.indexes.to) {
            throw new IllegalArgumentException("from can not be negative or greater than to for forward-only sequences");
        }
        return (ForwardOnlySequence)super.from(from);
    }

    @Override
    public ForwardOnlySequence<T> step(int step) {
        if (step < 0) {
            throw new IllegalArgumentException("step can never be negative for forward-only sequences");
        }
        return (ForwardOnlySequence)super.step(step);
    }

    public abstract <R> R loop(BiConsumer<Integer, T> var1);

    public <R> R loop(Consumer<T> consumer) {
        return this.loop((Integer index, T element) -> consumer.accept(element));
    }
}

