/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import ste.lloop.ForwardOnlySequence;
import ste.lloop.Loop;

public class LinesSequence
extends ForwardOnlySequence<String> {
    private BufferedReader reader;

    public LinesSequence(File file) {
        this(file == null ? null : file.toPath());
    }

    public LinesSequence(Path path) {
        if (path == null) {
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path does not exist: " + String.valueOf(path.toAbsolutePath()));
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path is not a regular file: " + String.valueOf(path.toAbsolutePath()));
        }
        if (!Files.isReadable(path)) {
            throw new IllegalArgumentException("Path is not readable: " + String.valueOf(path.toAbsolutePath()));
        }
        try {
            this.reader = Files.newBufferedReader(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error opening path: " + String.valueOf(path.toAbsolutePath()), e);
        }
    }

    public LinesSequence(BufferedReader reader) {
        this.reader = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R loop(BiConsumer<Integer, String> consumer) {
        if (this.reader == null) {
            return null;
        }
        if (this.indexes.step == 0) {
            return null;
        }
        AtomicInteger currentIndex = new AtomicInteger(0);
        Object r = this.indexes.loop((Integer targetIndex) -> {
            String line = null;
            while (currentIndex.get() <= targetIndex) {
                try {
                    line = this.reader.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading file lines", e);
                }
                if (line == null) {
                    Loop._break_(new Object[0]);
                }
                currentIndex.incrementAndGet();
            }
            consumer.accept((Integer)targetIndex, line);
        });
        return r;
        finally {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

