/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.function.Consumer;
import ste.lloop.ReturnValue;

public class NumericSequence {
    protected int from;
    protected Integer to;
    protected int step = 1;

    public NumericSequence from(int from) {
        this.from = from;
        return this;
    }

    public NumericSequence to(int to) {
        if (this.step < 0) {
            throw new IllegalArgumentException("a negative step is not allowed when to is set");
        }
        this.to = to;
        return this;
    }

    public NumericSequence step(int step) {
        if (this.to != null && step < 0) {
            throw new IllegalArgumentException("a negative step is not allowed when to is set");
        }
        this.step = step;
        return this;
    }

    public <R> R loop(Consumer<Integer> consumer) {
        if (this.step == 0) {
            return null;
        }
        Integer actualTo = this.to;
        Integer actualStep = this.step;
        if (this.to == null) {
            actualTo = this.step > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            actualStep = Math.abs(this.step);
        }
        try {
            boolean forward = this.from < actualTo;
            int increment = forward ? actualStep : -actualStep.intValue();
            for (int i = this.from; forward && i <= actualTo || !forward && i >= actualTo; i += increment) {
                consumer.accept(i);
            }
        }
        catch (ReturnValue e) {
            return e.value();
        }
        return null;
    }
}

