/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop.comparison;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import ste.lloop.Loop;

public class StreamComparison {
    private static final int LIST_SIZE = 50;
    private static final int SEARCH_ITERATIONS = 1000000;

    private StreamComparison() {
    }

    public static void main(String[] args) throws Exception {
        int i2;
        List<String> names = StreamComparison.generateNames();
        Random random = new Random();
        long lloopTime = 0L;
        long streamTime = 0L;
        System.out.println("starting");
        System.out.println("Total time for 1000000 iterations:");
        String[] randomNames = new String[1000000];
        Loop.on().from(0).to(999999).loop(i -> {
            randomNames[i.intValue()] = (String)names.get(random.nextInt(50));
        });
        for (i2 = 0; i2 < 1000000; ++i2) {
            long startStream = System.nanoTime();
            String NAME = randomNames[i2];
            Optional<String> found = names.stream().filter(name -> name.equals(NAME)).findFirst();
            streamTime += System.nanoTime() - startStream;
        }
        System.out.println("Stream: " + streamTime / 1000000L + " ms");
        for (i2 = 0; i2 < 1000000; ++i2) {
            String NAME = randomNames[i2];
            long startLloop = System.nanoTime();
            Loop.on(names).loop(name -> {
                if (name.equals(NAME)) {
                    Loop._break_(NAME);
                }
            });
            lloopTime += System.nanoTime() - startLloop;
        }
        System.out.println("\u03bbLoop: " + lloopTime / 1000000L + " ms");
    }

    private static List<String> generateNames() {
        return List.of("Maria", "Nushi", "Mohammed", "Jose", "Muhammad", "Mohamed", "Wei", "Mohammad", "Ahmed", "Yan", "Ali", "John", "David", "Li", "Abdul", "Ana", "Ying", "Michael", "Juan", "Anna", "Mary", "Jean", "Robert", "Daniel", "Luis", "Carlos", "James", "Antonio", "Joseph", "Hui", "Elena", "Francisco", "Hong", "Marie", "Min", "Lei", "Yu", "Ibrahim", "Peter", "Fatima", "Aleksandr", "Richard", "Xin", "Bin", "Paul", "Ping", "Lin", "Olga", "Sri", "Pedro");
    }
}

