/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import ste.lloop.ForwardOnlySequence;
import ste.lloop.Loop;

public class IterableSequence<T>
extends ForwardOnlySequence<T> {
    private final Iterable<T> iterable;

    public IterableSequence(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public <R> R loop(BiConsumer<Integer, T> consumer) {
        if (this.iterable == null) {
            return null;
        }
        if (this.indexes.step == 0) {
            return null;
        }
        Iterator iterator = this.iterable.iterator();
        AtomicInteger currentIndex = new AtomicInteger(0);
        return this.indexes.loop((Integer targetIndex) -> {
            Object element = null;
            while (currentIndex.get() <= targetIndex) {
                if (!iterator.hasNext()) {
                    Loop._break_(targetIndex);
                }
                element = iterator.next();
                currentIndex.incrementAndGet();
            }
            consumer.accept((Integer)targetIndex, (Object)element);
        });
    }
}

