/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import ste.lloop.ForwardOnlySequence;
import ste.lloop.Loop;

public class IteratorSequence<T>
extends ForwardOnlySequence<T> {
    private final Iterator<T> iterator;

    public IteratorSequence(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public <R> R loop(BiConsumer<Integer, T> consumer) {
        if (this.iterator == null) {
            return null;
        }
        if (this.indexes.step == 0) {
            return null;
        }
        AtomicInteger currentIndex = new AtomicInteger(0);
        return this.indexes.loop((Integer targetIndex) -> {
            Object element = null;
            while (currentIndex.get() <= targetIndex) {
                if (!this.iterator.hasNext()) {
                    Loop._break_(targetIndex);
                }
                element = this.iterator.next();
                currentIndex.incrementAndGet();
            }
            consumer.accept((Integer)targetIndex, (T)element);
        });
    }
}

