/*
 * Decompiled with CFR 0.152.
 */
package ste.lloop;

import java.io.BufferedReader;
import java.io.File;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ste.lloop.ArraySequence;
import ste.lloop.CharacterSequence;
import ste.lloop.Continue;
import ste.lloop.IterableSequence;
import ste.lloop.IteratorSequence;
import ste.lloop.LinesSequence;
import ste.lloop.ListSequence;
import ste.lloop.MapSequence;
import ste.lloop.NumericSequence;
import ste.lloop.ReturnValue;

public final class Loop {
    private Loop() {
    }

    public static NumericSequence on() {
        return new NumericSequence();
    }

    @SafeVarargs
    public static <T> ArraySequence<T> on(T ... items) {
        return new ArraySequence<T>(items);
    }

    public static <T> ListSequence<T> on(List<T> list) {
        return new ListSequence<T>(list);
    }

    public static <T> IterableSequence<T> on(Iterable<T> iterable) {
        return new IterableSequence<T>(iterable);
    }

    public static CharacterSequence on(CharSequence sequence) {
        return new CharacterSequence(sequence);
    }

    public static <K, V> MapSequence<K, V> on(Map<K, V> map) {
        return new MapSequence<K, V>(map);
    }

    public static <T> IteratorSequence<T> on(Enumeration<T> enumeration) {
        if (enumeration == null) {
            return new IteratorSequence(null);
        }
        return Loop.on(enumeration.asIterator());
    }

    public static <T> IteratorSequence<T> on(Iterator<T> iterator) {
        return new IteratorSequence<T>(iterator);
    }

    public static LinesSequence on(File file) {
        return new LinesSequence(file);
    }

    public static LinesSequence on(Path path) {
        return new LinesSequence(path);
    }

    public static LinesSequence on(BufferedReader reader) {
        return new LinesSequence(reader);
    }

    public static void brk(Object ... value) {
        if (value == null || value.length == 0) {
            throw new ReturnValue((Object)null);
        }
        throw new ReturnValue(value[0]);
    }

    public static void _break_(Object ... value) {
        Loop.brk(value);
    }

    public static void cntn() {
        throw new Continue();
    }

    public static void _continue_() {
        Loop.cntn();
    }
}

