/*
 * Decompiled with CFR 0.152.
 */
package io.github.stephenc.diffpatch;

import difflib.DiffUtils;
import difflib.Patch;
import difflib.PatchFailedException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="apply", threadSafe=true)
public class ApplyMojo
extends AbstractMojo {
    @Parameter(defaultValue="src/main/patches")
    private File patchDirectory;
    @Component
    private MavenProject project;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(defaultValue="${project.build.directory}/diffpatch-maven-plugin-markers")
    private File markersDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] patches = this.patchDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".patch");
            }
        });
        if (patches == null) {
            return;
        }
        this.markersDirectory.mkdirs();
        for (File p : patches) {
            List lines;
            this.getLog().info((CharSequence)String.format("Applying patch %s", p));
            try {
                lines = FileUtils.readLines((File)p, (String)this.encoding);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Could not read %s", p), (Exception)e);
            }
            int linesCount = lines.size();
            ArrayList<String> diff = new ArrayList<String>(linesCount);
            String oldFile = null;
            String newFile = null;
            block6: for (int i = 0; i < linesCount; ++i) {
                String line = (String)lines.get(i);
                if (line.startsWith("--- ") && i + 1 < linesCount && ((String)lines.get(i + 1)).startsWith("+++ ")) {
                    this.apply(diff, oldFile, newFile, p.lastModified());
                    int endIndex = line.indexOf(9, 4);
                    diff.clear();
                    oldFile = line.substring(4, endIndex == -1 ? line.length() : endIndex);
                    diff.add(line);
                    line = (String)lines.get(++i);
                    endIndex = line.indexOf(9, 4);
                    newFile = line.substring(4, endIndex == -1 ? line.length() : endIndex);
                    diff.add(line);
                    continue;
                }
                if (line.isEmpty()) continue;
                switch (line.charAt(0)) {
                    case ' ': 
                    case '+': 
                    case '-': 
                    case '@': {
                        diff.add(line);
                        continue block6;
                    }
                }
            }
            this.apply(diff, oldFile, newFile, p.lastModified());
        }
    }

    private void apply(List<String> diff, String oldFile, String newFile, long patchLastModified) throws MojoExecutionException {
        if (!diff.isEmpty() && newFile != null && oldFile != null) {
            Patch patch = DiffUtils.parseUnifiedDiff(diff);
            try {
                String markerName;
                boolean inPlace;
                if (oldFile.equals(newFile)) {
                    this.getLog().info((CharSequence)String.format("  Patching %s", oldFile));
                    inPlace = true;
                } else {
                    this.getLog().info((CharSequence)String.format("  Patching %s to %s", oldFile, newFile));
                    inPlace = false;
                }
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    byte[] bytes = digest.digest(newFile.getBytes("UTF-8"));
                    char[] chars = new char[bytes.length * 2];
                    for (int i = 0; i < bytes.length; ++i) {
                        chars[i * 2] = Character.forDigit(bytes[i] >> 4 & 0xF, 16);
                        chars[i * 2 + 1] = Character.forDigit(bytes[i] & 0xF, 16);
                    }
                    markerName = new String(chars);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("MD5 digest mandated by JLS");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("UTF-8 encoding mandated by JLS");
                }
                File patchedFile = new File(this.project.getBasedir(), newFile);
                File sourceFile = new File(this.project.getBasedir(), oldFile);
                File markerFile = new File(this.markersDirectory, markerName);
                if (markerFile.isFile() && markerFile.lastModified() >= Math.max(patchLastModified, patchedFile.lastModified())) {
                    this.getLog().info((CharSequence)String.format("  Skipping %s as not modified since last time", newFile));
                    return;
                }
                FileUtils.writeLines((File)patchedFile, (String)this.encoding, (Collection)patch.applyTo(FileUtils.readLines((File)sourceFile, (String)this.encoding)));
                new FileOutputStream(markerFile).close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not apply patch to " + newFile, (Exception)e);
            }
            catch (PatchFailedException e) {
                throw new MojoExecutionException("Could not apply patch to " + newFile, (Exception)((Object)e));
            }
        }
    }
}

