/*
 * Decompiled with CFR 0.152.
 */
package testoptimal.api.FSM;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import testoptimal.api.FSM.State;
import testoptimal.api.Util;

public class Model {
    private String uid = Util.genUID();
    @SerializedName(value="modelName")
    private String name;
    private String typeCode = "scxml";
    @SerializedName(value="childrenStates")
    private List<State> stateList = new ArrayList<State>();
    private List<String> pluginList = Arrays.asList("AGENT".split(","));

    public String getName() {
        return this.name;
    }

    public Model(String name_p) {
        this.uid = name_p.replace(" ", "_");
        this.name = name_p;
    }

    public State addState(String name_p) {
        State state = new State(name_p);
        this.assignPosition(state);
        this.stateList.add(state);
        return state;
    }

    private void assignPosition(State state_p) {
        int canvasWidth = 1500;
        int canvasHeight = 1000;
        int offsetLeft = 100;
        int offsetTop = 100;
        int offsetRight = 100;
        int offsetBottom = 100;
        int spacingHorizontal = 300;
        int spacingVertical = 200;
        state_p.setPosition(offsetLeft + spacingHorizontal * this.stateList.size() % canvasWidth, offsetTop + spacingHorizontal * this.stateList.size() / canvasWidth * spacingVertical, 75, 50);
    }

    public State addStateInitial(String name_p) {
        State state = new State(name_p);
        state.setInitialState(true);
        this.assignPosition(state);
        this.stateList.add(state);
        return state;
    }

    public State addStateFinal(String name_p) {
        State state = new State(name_p);
        state.setFinalState(true);
        this.assignPosition(state);
        this.stateList.add(state);
        return state;
    }

    public State findState(String name_p) {
        Optional<State> st = this.stateList.stream().filter(s -> s.getName().equals(name_p)).findFirst();
        return st.orElseGet(null);
    }

    public void saveToFile(String filePath_p) throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String modelJson = gson.toJson((Object)this);
        Util.writeToFile(filePath_p, modelJson);
    }

    public static Model fromFile(String filePath_p) throws Exception {
        StringBuffer modelJson = Util.readFile(filePath_p);
        Gson gson = new Gson();
        Model model = (Model)gson.fromJson(modelJson.toString(), Model.class);
        return model;
    }
}

