/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.adapter;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

public class LongTypeAdapter
extends TypeAdapter<Long> {
    public void write(JsonWriter out, Long value) throws IOException {
        out.value((Number)value);
    }

    public Long read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            String result = in.nextString();
            try {
                if (result.contains("E")) {
                    return new BigDecimal(result).longValue();
                }
                return Long.parseLong(result.replaceAll("\\,", "").trim(), 10);
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }
}

