/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.util;

import com.github.uuidcode.adapter.DateTypeAdapter;
import com.github.uuidcode.adapter.LongTypeAdapter;
import com.github.uuidcode.adapter.StringTypeAdapter;
import com.github.uuidcode.util.GenericOf;
import com.google.common.base.CaseFormat;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreUtil {
    protected static Logger logger = LoggerFactory.getLogger(CoreUtil.class);
    private static DateTimeParser[] dateTimeParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyyMMdd").getParser(), DateTimeFormat.forPattern((String)"yyyyMMddHH").getParser(), DateTimeFormat.forPattern((String)"yyyyMMddHHmm").getParser(), DateTimeFormat.forPattern((String)"yyyyMMddHHmmss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd HH").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm").getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"MM/dd/yyyy").getParser(), DateTimeFormat.forPattern((String)"MM/dd/yyyy HH").getParser(), DateTimeFormat.forPattern((String)"MM/dd/yyyy HH:mm").getParser(), DateTimeFormat.forPattern((String)"MM/dd/yyyy HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"dd/MMM/yyyy:HH:mm:ss").withLocale(Locale.US).getParser(), DateTimeFormat.forPattern((String)"yyyy.MM.dd").getParser(), DateTimeFormat.forPattern((String)"yyyy.MM.dd HH").getParser(), DateTimeFormat.forPattern((String)"yyyy.MM.dd HH:mm").getParser(), DateTimeFormat.forPattern((String)"yyyy.MM.dd HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss,SSS").getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss,SSSZ").getParser()};
    private static DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().append(null, dateTimeParsers).toFormatter();
    private static Gson gson = CoreUtil.getGsonBuilder().create();

    public static GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapter(Long.class, (Object)new LongTypeAdapter()).registerTypeAdapter(String.class, (Object)new StringTypeAdapter()).registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).disableHtmlEscaping().setPrettyPrinting().addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return fieldAttributes.getDeclaredClass().equals(Class.class);
            }

            public boolean shouldSkipClass(Class<?> aClass) {
                return false;
            }
        });
    }

    public static String createUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        FastDateFormat format = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static Date parseDateTime(String text) {
        if (text == null) {
            return null;
        }
        try {
            return dateTimeFormatter.parseDateTime(text).toDate();
        }
        catch (Throwable throwable) {
            try {
                new Date();
                long time = Date.parse(text);
                return new Date(time);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isNotEmpty(String value) {
        return !CoreUtil.isEmpty(value);
    }

    public static String wrapWithDoubleQuote(String text) {
        return CoreUtil.wrap(text, "\"");
    }

    public static String wrapWithBrace(String text) {
        return CoreUtil.wrap(text, CoreUtil.leftBrace(), CoreUtil.rightBrace());
    }

    public static String wrapWithAngleBracket(String text) {
        return CoreUtil.wrap(text, CoreUtil.leftAngleBracket(), CoreUtil.rightAngleBracket());
    }

    public static String wrap(String text, String left, String right) {
        return left + text + right;
    }

    public static String wrap(String text, String left) {
        return CoreUtil.wrap(text, left, left);
    }

    public static String toFirstCharUpperCase(String name) {
        if (CoreUtil.isEmpty(name)) {
            return CoreUtil.empty();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String toFirstCharLowerCase(String name) {
        if (CoreUtil.isEmpty(name)) {
            return CoreUtil.empty();
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static List<String> splitWithUnderscore(String text) {
        return CoreUtil.split(text, CoreUtil.underscore());
    }

    public static List<String> split(String text, String delimiter) {
        if (text == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(text.split(delimiter)).collect(Collectors.toList());
    }

    public static String generate(String text, int size) {
        return IntStream.range(0, size).mapToObj(i -> text).collect(Collectors.joining());
    }

    public static String joining(List<String> list) {
        return CoreUtil.joining(list, CoreUtil.comma());
    }

    public static String joiningWithCommaAndSpace(List<String> list) {
        return CoreUtil.joining(list, CoreUtil.commaAndSpace());
    }

    public static String joining(List<String> list, String delimiter) {
        if (list == null) {
            return CoreUtil.empty();
        }
        return list.stream().collect(Collectors.joining(delimiter));
    }

    public static <E extends Enum<E>> List<E> toList(Class<E> enumClass) {
        return new ArrayList<E>(EnumSet.allOf(enumClass));
    }

    public static void setContent(File file, String data) {
        block2: {
            try {
                FileUtils.writeStringToFile((File)file, (String)data, (Charset)Charset.defaultCharset());
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error setContent", (Throwable)e);
            }
        }
    }

    public static String getContent(File file) {
        try {
            return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
            return CoreUtil.empty();
        }
    }

    public static String getContentFromResource(String name) {
        String fileName = CoreUtil.class.getClassLoader().getResource(name).getFile();
        File file = new File(fileName);
        return CoreUtil.getContent(file);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)gson.fromJson(json, clazz);
    }

    public static List<Map> fromJsonToList(String json) {
        return (List)gson.fromJson(json, new GenericOf<List, Map>(List.class, Map.class));
    }

    public static String toJson(Object object) {
        return gson.toJson(object);
    }

    public static <T> List<T> asList(T ... array) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : array) {
            list.add(t);
        }
        return list;
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String lineSeparator(int size) {
        return CoreUtil.generate(CoreUtil.lineSeparator(), size);
    }

    public static String indent(int size) {
        return CoreUtil.generate("    ", size);
    }

    public static String indent() {
        return CoreUtil.indent(1);
    }

    public static String indent(String content) {
        if (CoreUtil.isEmpty(content)) {
            return CoreUtil.empty();
        }
        return CoreUtil.indent() + content;
    }

    public static String commaAndSpace() {
        return CoreUtil.comma() + CoreUtil.space();
    }

    public static String comma() {
        return ",";
    }

    public static String space() {
        return " ";
    }

    public static String equal() {
        return "=";
    }

    public static String sharp() {
        return "#";
    }

    public static String underscore() {
        return "_";
    }

    public static String empty() {
        return "";
    }

    public static String semicolon() {
        return ";";
    }

    public static String slash() {
        return "/";
    }

    public static String backslash() {
        return "\\";
    }

    public static String dot() {
        return ".";
    }

    public static String leftBrace() {
        return "{";
    }

    public static String rightBrace() {
        return "}";
    }

    public static String leftParenthesis() {
        return "(";
    }

    public static String rightParenthesis() {
        return ")";
    }

    public static String leftAngleBracket() {
        return "<";
    }

    public static String rightAngleBracket() {
        return ">";
    }

    public static String underscoreToLowerCamel(String value) {
        if (value.contains(CoreUtil.underscore())) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, value);
        }
        return CoreUtil.toFirstCharLowerCase(value);
    }

    public static String underscoreToUpperCamel(String value) {
        if (value.contains(CoreUtil.underscore())) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, value);
        }
        return CoreUtil.toFirstCharUpperCase(value);
    }

    public static String dotToSlash(String value) {
        return value.replaceAll(CoreUtil.backslash() + CoreUtil.dot(), CoreUtil.slash());
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String toQueryStringWithQuestionMark(Object object) {
        return CoreUtil.toQueryStringWithQuestionMark(FieldNamingPolicy.IDENTITY, object);
    }

    public static String toQueryStringWithQuestionMark(FieldNamingPolicy fieldNamePolicy, Object object) {
        return "?" + CoreUtil.toQueryString(fieldNamePolicy, object);
    }

    public static String toQueryString(Object object) {
        return CoreUtil.toQueryString(FieldNamingPolicy.IDENTITY, object);
    }

    public static String toQueryString(FieldNamingPolicy fieldNamePolicy, Object object) {
        if (object == null) {
            return "";
        }
        return CoreUtil.toNameValuePairList(fieldNamePolicy, object).stream().map(p -> p.getName() + "=" + CoreUtil.urlEncode(p.getValue())).collect(Collectors.joining("&"));
    }

    public static List<NameValuePair> toNameValuePairList(Object object) {
        return CoreUtil.toNameValuePairList(FieldNamingPolicy.IDENTITY, object);
    }

    public static List<NameValuePair> toNameValuePairList(FieldNamingPolicy fieldNamePolicy, Object object) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (object == null) {
            return list;
        }
        if (object instanceof Map) {
            return CoreUtil.toNameValuePairList(fieldNamePolicy, (Map)object);
        }
        return Arrays.stream(FieldUtils.getAllFields(object.getClass())).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isFinal(field.getModifiers())).map(field -> {
            field.setAccessible(true);
            Object currentObject = null;
            try {
                currentObject = field.get(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (currentObject != null) {
                String value = CoreUtil.getValue(currentObject);
                String name = fieldNamePolicy.translateName(field);
                return new BasicNameValuePair(name, value);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<NameValuePair> toNameValuePairList(FieldNamingPolicy fieldNamePolicy, Map<?, ?> object) {
        Map<?, ?> map = object;
        return map.entrySet().stream().map(i -> {
            try {
                Field field = CoreUtil.createField(i.getKey().toString());
                String name = fieldNamePolicy.translateName(field);
                String value = CoreUtil.getValue(i.getValue());
                return new BasicNameValuePair(name, value);
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static String getValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return CoreUtil.format(date);
        }
        return value.toString();
    }

    private static Field createField(String name) throws Exception {
        Constructor constructor = Field.class.getDeclaredConstructor(Class.class, String.class, Class.class, Integer.TYPE, Integer.TYPE, String.class, byte[].class);
        constructor.setAccessible(true);
        return (Field)constructor.newInstance(null, name, null, 0, 0, null, new byte[0]);
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
            return "";
        }
    }

    public static String urlDecode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
            return "";
        }
    }
}

