/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.builder.selenium;

import com.github.uuidcode.util.CoreUtil;
import com.github.uuidcode.util.StringStream;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverBuilder {
    protected static Logger logger = LoggerFactory.getLogger(ChromeDriverBuilder.class);
    private ChromeDriver driver;

    public static ChromeDriverBuilder of() {
        return new ChromeDriverBuilder();
    }

    public static ChromeDriverBuilder headless() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"headless"});
        return new ChromeDriverBuilder(options);
    }

    private ChromeDriverBuilder(ChromeOptions options) {
        this.driver = new ChromeDriver(options);
    }

    private ChromeDriverBuilder() {
        this(new ChromeOptions());
    }

    public ChromeDriverBuilder click(WebElement webElement) {
        webElement.click();
        return this.sleep();
    }

    public ChromeDriverBuilder loadUrl(String url) {
        this.driver.get(url);
        return this.sleep();
    }

    public ChromeDriverBuilder sleep() {
        return this.sleep(2);
    }

    public ChromeDriverBuilder sleep(int second) {
        block2: {
            try {
                Thread.sleep(second * 1000);
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error sleep", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder clickByClassName(String className) {
        block2: {
            try {
                this.click(this.driver.findElementByClassName(className));
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error clickByClassName", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder clickById(String id) {
        block2: {
            try {
                WebElement element = this.driver.findElementById(id);
                this.click(element);
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error clickById", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder sendKeyByClassName(String className, String value) {
        block2: {
            try {
                WebElement element = this.driver.findElementByClassName(className);
                this.sendKey(element, value);
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error sendKeyByClassName", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder sendKeyById(String id, String value) {
        block2: {
            try {
                WebElement element = this.driver.findElementById(id);
                this.sendKey(element, value);
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error sendKeyById", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder sendKey(WebElement webElement, String value) {
        webElement.sendKeys(new CharSequence[]{value});
        return this;
    }

    public ChromeDriverBuilder scrollDownByClassName(String className) {
        String method = "document.getElementsByClassName('selector').scrollTop".replaceAll("selector", className);
        return this.scroll(method);
    }

    public ChromeDriverBuilder scrollDownById(String id) {
        String method = "document.getElementById('selector').scrollTop".replaceAll("selector", id);
        return this.scroll(method);
    }

    public ChromeDriverBuilder scroll(String value) {
        String script = StringStream.of().add("var scrollTop = expression;".replaceAll("expression", value)).add("window.scrollTo(0, scrollTop);").joiningWithSpace();
        this.driver.executeScript(script, new Object[0]);
        return this.sleep();
    }

    public ChromeDriverBuilder scroll(int scrollTop) {
        return this.scroll(String.valueOf(scrollTop));
    }

    public ChromeDriverBuilder quit() {
        Optional.ofNullable(this.driver).ifPresent(RemoteWebDriver::quit);
        return this;
    }

    public boolean containsAtSource(String content) {
        return this.driver.getPageSource().contains(content);
    }

    public boolean loadUrlAndContainsAtSource(String url, String content) {
        this.loadUrl(url);
        return this.driver.getPageSource().contains(content);
    }

    public ChromeDriver getDriver() {
        return this.driver;
    }

    public ChromeDriverBuilder setInnerHTMLByClassName(String className, String content) {
        content = CoreUtil.splitListWithNewLine(content).stream().map(line -> line.replaceAll("'", "'")).collect(Collectors.joining("\\n"));
        WebElement element = this.driver.findElementByClassName(className);
        String script = "arguments[0].innerHTML= '" + content + "'";
        this.driver.executeScript(script, new Object[]{element});
        return this.sleep();
    }
}

