/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.builder.pojo;

import com.github.uuidcode.builder.pojo.Pojo;
import com.github.uuidcode.builder.pojo.Property;
import com.github.uuidcode.util.CoreUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PojoBuilder {
    public static Map<String, String> nameConverterMap = new HashMap<String, String>();
    public static Set<String> includedFieldSet = new HashSet<String>();
    public static Set<String> excludedFieldSet = new HashSet<String>();
    public static Map<String, String> typeConvertMap = new HashMap<String, String>(){
        {
            this.put("int", "Long");
            this.put("bigint", "Long");
            this.put("varbinary", "String");
            this.put("enum", "String");
            this.put("varchar", "String");
            this.put("char", "String");
            this.put("timestamp", "Date");
            this.put("date", "Date");
        }
    };
    private String className;
    private String targetDirectory;
    private String packageName;
    private List<Property> propertyList;

    public String getPackageName() {
        return this.packageName;
    }

    public PojoBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public static boolean isAvailableField(String name) {
        if (includedFieldSet.isEmpty() && excludedFieldSet.isEmpty()) {
            return true;
        }
        if (includedFieldSet.isEmpty()) {
            return !excludedFieldSet.contains(name);
        }
        if (excludedFieldSet.isEmpty()) {
            return includedFieldSet.contains(name);
        }
        return false;
    }

    public PojoBuilder setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public PojoBuilder setClassName(String className) {
        this.className = className;
        return this;
    }

    public Property toPropert(String line) {
        line = line.trim();
        List<String> itemList = CoreUtil.splitListWithSpace(line);
        String name = itemList.get(0).replaceAll("`", "");
        String type = itemList.get(1);
        String convertedType = this.getConvertedType(type);
        return Property.of().setName(name).setType(convertedType).setIsList(false);
    }

    public PojoBuilder setSchema(String schema) {
        this.propertyList = CoreUtil.splitListWithNewLine(schema).stream().map(this::toPropert).collect(Collectors.toList());
        return this;
    }

    public PojoBuilder setJson(String json) {
        Map<String, Object> map = CoreUtil.fromJsonToMap(json);
        this.propertyList = PojoBuilder.getPropertyListFromMap(map);
        return this;
    }

    public static List<Property> getPropertyListFromMap(Map<String, Object> map) {
        return map.entrySet().stream().filter(entry -> PojoBuilder.isAvailableField((String)entry.getKey())).map(Property::of).collect(Collectors.toList());
    }

    private String getConvertedType(String type) {
        return typeConvertMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(type)).findFirst().map(Map.Entry::getValue).orElse("String");
    }

    public static String getJavaType(String name) {
        if (name.endsWith("List")) {
            name = name.substring(0, name.length() - 4);
            name = CoreUtil.toFirstCharUpperCase(name);
        }
        String type = nameConverterMap.getOrDefault(name, name);
        return CoreUtil.toFirstCharUpperCase(type);
    }

    public PojoBuilder addNameConvert(String oldName, String newName) {
        nameConverterMap.put(oldName, newName);
        return this;
    }

    public PojoBuilder addIncludeField(String field) {
        includedFieldSet.add(field);
        return this;
    }

    public PojoBuilder addExcludeField(String field) {
        excludedFieldSet.add(field);
        return this;
    }

    public static PojoBuilder of() {
        return new PojoBuilder();
    }

    public void build() {
        Pojo.of().setPackageName(this.packageName).setClassName(this.className).setPropertyList(this.propertyList).build().stream().filter(Pojo::hasProperty).forEach(pojo -> pojo.generateAndSave(this.targetDirectory));
    }
}

