/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.builder.selenium;

import com.github.uuidcode.builder.selenium.LoginForm;
import com.github.uuidcode.util.CoreUtil;
import com.github.uuidcode.util.StringStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverBuilder {
    protected static Logger logger = LoggerFactory.getLogger(ChromeDriverBuilder.class);
    private ChromeDriver driver;
    private String host;
    private int waitSecond = 2;

    public int getWaitSecond() {
        return this.waitSecond;
    }

    public ChromeDriverBuilder setWaitSecond(int waitSecond) {
        this.waitSecond = waitSecond;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ChromeDriverBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public static ChromeDriverBuilder of() {
        return new ChromeDriverBuilder();
    }

    public static ChromeDriverBuilder headless() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"headless"});
        return new ChromeDriverBuilder(options);
    }

    private ChromeDriverBuilder(ChromeOptions options) {
        this.driver = new ChromeDriver(options);
    }

    private ChromeDriverBuilder() {
        this(new ChromeOptions());
    }

    public ChromeDriverBuilder click(WebElement webElement) {
        webElement.click();
        return this.sleep();
    }

    public ChromeDriverBuilder loadUrl(String url) {
        if (this.host != null) {
            url = this.host + url;
        }
        this.driver.get(url);
        return this.sleep();
    }

    public ChromeDriverBuilder sleep() {
        return this.sleep(this.waitSecond);
    }

    public ChromeDriverBuilder sleep(int second) {
        block2: {
            try {
                Thread.sleep(second * 1000);
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error sleep", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder click(Function<String, WebElement> function, String selector) {
        block2: {
            try {
                this.click(function.apply(selector));
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error clickByClassName", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder clickByClassName(String className) {
        return this.click(arg_0 -> ((ChromeDriver)this.driver).findElementByClassName(arg_0), className);
    }

    public ChromeDriverBuilder clickById(String id) {
        return this.click(arg_0 -> ((ChromeDriver)this.driver).findElementById(arg_0), id);
    }

    public ChromeDriverBuilder clickBySelector(String selector) {
        return this.click(arg_0 -> ((ChromeDriver)this.driver).findElementByCssSelector(arg_0), selector);
    }

    public ChromeDriverBuilder sendKey(Function<String, WebElement> function, String selector, String value) {
        block2: {
            try {
                this.sendKey(function.apply(selector), value);
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error clickByClassName", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder sendKeyByClassName(String className, String value) {
        return this.sendKey(arg_0 -> ((ChromeDriver)this.driver).findElementByClassName(arg_0), className, value);
    }

    public ChromeDriverBuilder sendKeyById(String id, String value) {
        return this.sendKey(arg_0 -> ((ChromeDriver)this.driver).findElementById(arg_0), id, value);
    }

    public ChromeDriverBuilder sendKeyBySelector(String selector, String value) {
        return this.sendKey(arg_0 -> ((ChromeDriver)this.driver).findElementByCssSelector(arg_0), selector, value);
    }

    public ChromeDriverBuilder sendKey(WebElement webElement, String value) {
        webElement.sendKeys(new CharSequence[]{value});
        return this;
    }

    public ChromeDriverBuilder scrollDownByClassName(String className) {
        String method = "document.getElementsByClassName('selector').scrollTop".replaceAll("selector", className);
        return this.scroll(method);
    }

    public ChromeDriverBuilder scrollDownById(String id) {
        String method = "document.getElementById('selector').scrollTop".replaceAll("selector", id);
        return this.scroll(method);
    }

    public ChromeDriverBuilder scroll(String value) {
        String script = StringStream.of().add("var scrollTop = expression;".replaceAll("expression", value)).add("window.scrollTo(0, scrollTop);").joiningWithSpace();
        this.driver.executeScript(script, new Object[0]);
        return this.sleep();
    }

    public ChromeDriverBuilder scroll(int scrollTop) {
        return this.scroll(String.valueOf(scrollTop));
    }

    public ChromeDriverBuilder quit() {
        Optional.ofNullable(this.driver).ifPresent(RemoteWebDriver::quit);
        return this;
    }

    public boolean containsAtSource(String content) {
        return this.driver.getPageSource().contains(content);
    }

    public boolean loadUrlAndContainsAtSource(String url, String content) {
        this.loadUrl(url);
        return this.driver.getPageSource().contains(content);
    }

    public ChromeDriver getDriver() {
        return this.driver;
    }

    public ChromeDriverBuilder setInnerHTMLByClassName(String className, String content) {
        content = CoreUtil.splitListWithNewLine(content).stream().map(line -> line.replaceAll("'", "'")).collect(Collectors.joining("\\n"));
        WebElement element = this.driver.findElementByClassName(className);
        String script = "arguments[0].innerHTML= '" + content + "'";
        this.driver.executeScript(script, new Object[]{element});
        return this.sleep();
    }

    public ChromeDriverBuilder login(LoginForm loginForm) {
        List<String> valueList = CoreUtil.splitListWithColon(CoreUtil.base64Decode(loginForm.getToken()));
        this.loadUrl(loginForm.getUri());
        this.sendKeyBySelector(loginForm.getFirst(), valueList.get(0));
        this.sendKeyBySelector(loginForm.getSecond(), valueList.get(1));
        return this.clickBySelector(loginForm.getThird());
    }
}

