/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.builder.process;

import com.github.uuidcode.builder.process.ProcessBuilder;
import com.github.uuidcode.util.CoreUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MavenProcessBuilder
implements ProcessBuilder {
    private List<String> optionList = new ArrayList<String>();

    public static MavenProcessBuilder of() {
        return new MavenProcessBuilder();
    }

    MavenProcessBuilder() {
        this.optionList.add("mvn");
    }

    public MavenProcessBuilder dependencyBuildClasspath() {
        this.optionList.add("dependency:build-classpath");
        return this;
    }

    @Override
    public String getCommand() {
        return this.optionList.stream().collect(Collectors.joining(" "));
    }

    public List<String> getLibraryList() {
        return this.getLibraryPathList().stream().map(CoreUtil::splitListWithFileSeparator).map(CoreUtil::last).collect(Collectors.toList());
    }

    public List<String> getLibraryPathList() {
        String result = this.dependencyBuildClasspath().runAndGetResult();
        List<String> list = CoreUtil.splitListWithNewLine(result);
        int index = this.getDependenciesClasspathIndex(list);
        String path = list.get(index + 1);
        return CoreUtil.splitListWithFilePathSeparator(path);
    }

    private int getDependenciesClasspathIndex(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).contains("Dependencies classpath")) continue;
            return i;
        }
        return -1;
    }
}

