/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.builder.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tail
extends Thread {
    protected static Logger logger = LoggerFactory.getLogger(Tail.class);
    private int sleepSecond = 3;
    private File file;

    public Tail setFile(String fileName) {
        return this.setFile(new File(fileName));
    }

    public Tail setFile(File file) {
        this.file = file;
        return this;
    }

    public Tail setSleepSecond(int sleepSecond) {
        this.sleepSecond = sleepSecond;
        return this;
    }

    public static Tail of() {
        return new Tail();
    }

    @Override
    public void run() {
        this.file.delete();
        while (true) {
            this.sleep();
            if (!this.file.exists()) continue;
            this.read();
        }
    }

    private void sleep() {
        try {
            Thread.sleep(1000 * this.sleepSecond);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void read() {
        block15: {
            try (BufferedReader reader = this.createReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block15;
                logger.error(">>> Tail run error", (Throwable)e);
            }
        }
    }

    private BufferedReader createReader() throws FileNotFoundException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
    }
}

