/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.builder.process;

import com.github.uuidcode.util.CoreUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ProcessBuilder {
    public static final Logger logger = LoggerFactory.getLogger(ProcessBuilder.class);

    public String getCommand();

    default public Process run() {
        return Optional.ofNullable(this.getCommand()).map(this::logCommand).map(CoreUtil::exec).orElse(null);
    }

    default public String runAndGetResult() {
        return Optional.ofNullable(this.run()).map(Process::getInputStream).map(CoreUtil::inputStreamToString).orElse(null);
    }

    default public List<String> runAndGetResultList() {
        return Optional.ofNullable(this.runAndGetResult()).map(CoreUtil::splitListWithNewLine).orElse(new ArrayList());
    }

    default public String logCommand(String command) {
        if (logger.isDebugEnabled()) {
            logger.debug(">>> run command: {}", (Object)command);
        }
        return command;
    }
}

