/*
 * Decompiled with CFR 0.152.
 */
package com.github.uuidcode.builder.selenium;

import com.github.uuidcode.builder.selenium.LoginForm;
import com.github.uuidcode.util.CoreUtil;
import com.github.uuidcode.util.StringStream;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverBuilder {
    protected static Logger logger = LoggerFactory.getLogger(ChromeDriverBuilder.class);
    private ChromeDriver driver;
    private String host;
    private int sleepSecond = 2;
    private int scrollTopOffset = 200;

    public ChromeDriverBuilder setScrollTopOffset(int scrollTopOffset) {
        this.scrollTopOffset = scrollTopOffset;
        return this;
    }

    public int getSleepSecond() {
        return this.sleepSecond;
    }

    public ChromeDriverBuilder setSleepSecond(int sleepSecond) {
        this.sleepSecond = sleepSecond;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ChromeDriverBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public static ChromeDriverBuilder of() {
        return new ChromeDriverBuilder();
    }

    public static ChromeDriverBuilder headless() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"headless"});
        return new ChromeDriverBuilder(options);
    }

    private ChromeDriverBuilder(ChromeOptions options) {
        this.driver = new ChromeDriver(options);
        Runtime.getRuntime().addShutdownHook(this.createShutdownHook());
    }

    private Thread createShutdownHook() {
        return new Thread(() -> this.driver.quit());
    }

    private ChromeDriverBuilder() {
        this(new ChromeOptions());
    }

    private Wait getWait() {
        return new FluentWait((Object)this.driver).withTimeout(Duration.ofSeconds(5L)).pollingEvery(Duration.ofSeconds(1L));
    }

    public ChromeDriverBuilder scrollDownByClassName(String className) {
        String method = "document.getElementsByClassName('selector').scrollTop".replaceAll("selector", className);
        return this.scroll(method);
    }

    public ChromeDriverBuilder scrollDownById(String id) {
        String method = "document.getElementById('selector').scrollTop".replaceAll("selector", id);
        return this.scroll(method);
    }

    public ChromeDriverBuilder scroll(int value) {
        return this.scroll(String.valueOf(value));
    }

    public ChromeDriverBuilder scroll(String value) {
        String script = StringStream.of().add("var scrollTop = expression;".replaceAll("expression", value)).add("window.scrollTo(0, scrollTop);").joiningWithSpace();
        this.driver.executeScript(script, new Object[0]);
        return this.sleep();
    }

    private WebElement wait(By by) {
        Wait wait = this.getWait();
        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)by));
        WebElement element = this.driver.findElement(by);
        this.scroll(element.getLocation().y - this.scrollTopOffset);
        return element;
    }

    public ChromeDriverBuilder loadUrl(String url) {
        if (this.host != null) {
            url = this.host + url;
        }
        this.driver.get(url);
        return this.sleep();
    }

    public ChromeDriverBuilder sleep() {
        return this.sleep(this.sleepSecond);
    }

    public ChromeDriverBuilder sleep(int second) {
        block2: {
            try {
                Thread.sleep(second * 1000);
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error sleep", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder click(By by) {
        block2: {
            try {
                this.wait(by).click();
                this.sleep();
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error ChromeDriverBuilder click", t);
            }
        }
        return this;
    }

    public ChromeDriverBuilder sendKey(By by, String value) {
        block2: {
            try {
                WebElement webElement = this.wait(by);
                webElement.clear();
                webElement.sendKeys(new CharSequence[]{value});
            }
            catch (Throwable t) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(">>> error ChromeDriverBuilder click", t);
            }
        }
        return this.sleep();
    }

    public ChromeDriverBuilder quit() {
        Optional.ofNullable(this.driver).ifPresent(RemoteWebDriver::quit);
        return this;
    }

    public boolean containsAtSource(String content) {
        return this.driver.getPageSource().contains(content);
    }

    public boolean loadUrlAndContainsAtSource(String url, String content) {
        this.loadUrl(url);
        return this.driver.getPageSource().contains(content);
    }

    public ChromeDriver getChromeDriver() {
        return this.driver;
    }

    public ChromeDriverBuilder setInnerHTML(By by, String content) {
        content = CoreUtil.splitListWithNewLine(content).stream().map(CoreUtil::escapeSingleQuotation).collect(Collectors.joining("\\n"));
        WebElement element = this.driver.findElement(by);
        String script = "arguments[0].innerHTML= '" + content + "'";
        this.driver.executeScript(script, new Object[]{element});
        return this.sleep();
    }

    public ChromeDriverBuilder script(String script) {
        this.driver.executeScript(script, new Object[0]);
        return this.sleep();
    }

    public ChromeDriverBuilder jQueryClick(String selector) {
        String script = "$('" + selector + "').get(0).click();";
        if (logger.isDebugEnabled()) {
            logger.debug(">>> jQueryClick script: {}", (Object)CoreUtil.toJson(script));
        }
        return this.script(script);
    }

    public ChromeDriverBuilder login(LoginForm loginForm) {
        List<String> valueList = CoreUtil.splitListWithColon(CoreUtil.base64Decode(loginForm.getToken()));
        this.loadUrl(loginForm.getUri());
        this.sendKey(By.cssSelector((String)loginForm.getFirst()), valueList.get(0));
        this.sendKey(By.cssSelector((String)loginForm.getSecond()), valueList.get(1));
        return this.click(By.cssSelector((String)loginForm.getThird()));
    }
}

