/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.safeAPIKeyStore.client;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryonet.Client;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.Listener;
import com.github.vatbub.safeAPIKeyStore.client.BadRequestException;
import com.github.vatbub.safeAPIKeyStore.client.InternalServerException;
import com.github.vatbub.safeAPIKeyStore.client.MultipleRequestsWithSameRSAKeyException;
import com.github.vatbub.safeAPIKeyStore.common.APIKeyRequest;
import com.github.vatbub.safeAPIKeyStore.common.APIKeyResponse;
import com.github.vatbub.safeAPIKeyStore.common.BadRequestExceptionInternalImpl;
import com.github.vatbub.safeAPIKeyStore.common.InternalServerExceptionInternalImpl;
import com.github.vatbub.safeAPIKeyStore.common.KryoCommon;
import com.github.vatbub.safeAPIKeyStore.common.MultipleRequestsWithSameRSAKeyExceptionInternalImpl;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeoutException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class APIKeyClient {
    private APIKeyClient() {
        throw new IllegalStateException("Class may not be instantiated");
    }

    public static String getApiKey(String serverHost, String apiKeyName) throws InternalServerException, TimeoutException, IOException {
        return APIKeyClient.getApiKey(serverHost, 1650, apiKeyName);
    }

    public static String getApiKey(String serverHost, int serverPort, String apiKeyName) throws TimeoutException, InternalServerException, IOException {
        return APIKeyClient.getApiKey(serverHost, serverPort, apiKeyName, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getApiKey(String serverHost, int serverPort, String apiKeyName, int responseTimeoutInMilliSeconds) throws IOException, TimeoutException, InternalServerException {
        Client kryoClient = new Client();
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            APIKeyRequest request = new APIKeyRequest(keyPair.getPublic().getEncoded(), apiKeyName);
            KryoCommon.registerClasses((Kryo)kryoClient.getKryo());
            kryoClient.start();
            final Object[] responseObject = new Object[1];
            kryoClient.addListener(new Listener(){

                public void received(Connection connection, Object object) {
                    responseObject[0] = object;
                }
            });
            kryoClient.connect(5000, serverHost, serverPort);
            kryoClient.sendTCP((Object)request);
            int sleepTime = responseTimeoutInMilliSeconds / 100;
            int numberOfSleeps = 0;
            while (responseObject[0] == null || responseObject[0] instanceof FrameworkMessage.KeepAlive) {
                if (numberOfSleeps * sleepTime >= responseTimeoutInMilliSeconds) {
                    throw new TimeoutException("Timed out while waiting for a response from the server");
                }
                Thread.sleep(sleepTime);
                ++numberOfSleeps;
            }
            Object object = responseObject[0];
            if (object instanceof BadRequestExceptionInternalImpl) {
                throw new BadRequestException(((BadRequestExceptionInternalImpl)object).getMessage());
            }
            if (object instanceof InternalServerExceptionInternalImpl) {
                throw new InternalServerException(((InternalServerExceptionInternalImpl)object).getMessage());
            }
            if (object instanceof MultipleRequestsWithSameRSAKeyExceptionInternalImpl) {
                throw new MultipleRequestsWithSameRSAKeyException(((MultipleRequestsWithSameRSAKeyExceptionInternalImpl)object).getMessage());
            }
            if (object instanceof APIKeyResponse) {
                APIKeyResponse response = (APIKeyResponse)object;
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, keyPair.getPrivate());
                String string = new String(cipher.doFinal(response.getEncryptedAPIKey()), response.getEncoding());
                return string;
            }
            try {
                throw new IllegalStateException("Illegal response from server. Server sent object of type " + object.getClass().getName());
            }
            catch (BadRequestException | InterruptedException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                e.printStackTrace();
                String string = null;
                return string;
            }
        }
        finally {
            kryoClient.stop();
        }
    }
}

