/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.safeAPIKeyStore;

import com.github.vatbub.common.core.Common;
import com.github.vatbub.common.core.logging.FOKLogger;
import com.github.vatbub.safeAPIKeyStore.server.Server;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class SafeAPIKeyStoreTestBase {
    public static final String apiKey1Name = "apiKey1";
    public static final String apiKey1Value = "12345";
    public static final String apiKey2Name = "apiKey2";
    public static final String apiKey2Value = "vfcdr567zutrf76t8uiohjl\u00e4kB;NLM:,-jlhkgi&(RTZF)/UOHJL\u00c4BKVGJCuftr86ZUOGH\u00c4hjklbnvgjcUTFDr6zi";
    public static final int port = 1650;
    private static final String apiKeysFileName = "apiKeysForTesting.properties";
    private static Server server;
    private static Properties apiKeysForTesting;

    public static Properties getApiKeysForTesting() {
        return apiKeysForTesting;
    }

    public static Server getServer() {
        return server;
    }

    @BeforeClass
    public static void oneTimeSetUp() throws InterruptedException, IOException, IllegalAccessException {
        Common.getInstance().setAppName("SafeAPIKeyStoreServerTests");
        File apiKeyFile = SafeAPIKeyStoreTestBase.createApiKeyFile();
        FOKLogger.info((String)SafeAPIKeyStoreTestBase.class.getName(), (String)"Launching server...");
        server = new Server(1650, apiKeyFile.getAbsolutePath());
        Awaitility.await().atMost(5L, TimeUnit.SECONDS);
    }

    public static File createApiKeyFile() throws IOException {
        File apiKeyFile = new File(Common.getInstance().getAndCreateAppDataPath() + apiKeysFileName);
        if (apiKeyFile.exists()) {
            Files.delete(apiKeyFile.toPath());
        }
        apiKeysForTesting.setProperty(apiKey1Name, apiKey1Value);
        apiKeysForTesting.setProperty(apiKey2Name, apiKey2Value);
        apiKeysForTesting.store(new FileWriter(apiKeyFile), "API Keys for unit tests of " + Common.getInstance().getAppName());
        return apiKeyFile;
    }

    @AfterClass
    public static void oneTimeTeardown() {
        FOKLogger.info((String)SafeAPIKeyStoreTestBase.class.getName(), (String)"Shutting server down...");
        SafeAPIKeyStoreTestBase.getServer().stop();
    }

    @Before
    public void setUp() {
        SafeAPIKeyStoreTestBase.getServer().resetPermanently();
    }

    static {
        apiKeysForTesting = new Properties();
    }
}

