/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.safeAPIKeyStore.server;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.Listener;
import com.github.vatbub.common.core.Common;
import com.github.vatbub.common.core.ListCommon;
import com.github.vatbub.common.core.logging.FOKLogger;
import com.github.vatbub.safeAPIKeyStore.common.APIKeyRequest;
import com.github.vatbub.safeAPIKeyStore.common.APIKeyResponse;
import com.github.vatbub.safeAPIKeyStore.common.BadRequestExceptionInternalImpl;
import com.github.vatbub.safeAPIKeyStore.common.InternalServerExceptionInternalImpl;
import com.github.vatbub.safeAPIKeyStore.common.KryoCommon;
import com.github.vatbub.safeAPIKeyStore.common.MultipleRequestsWithSameRSAKeyExceptionInternalImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.crypto.Cipher;
import org.apache.commons.lang.exception.ExceptionUtils;

public class Server {
    private static final String FILE_NAME_FOR_USED_PUBLIC_KEYS = "usedPublicKeys";
    private Properties apiKeys;
    private com.esotericsoftware.kryonet.Server kryoServer;
    private ArrayList<byte[]> usedKeys;

    public Server(int port, String apiKeysFileName) throws IOException {
        this(port, new File(apiKeysFileName));
    }

    public Server(int port, File apiKeysFile) throws IOException {
        FOKLogger.info((String)Server.class.getName(), (String)("Resolving the apiKeysFile to '" + apiKeysFile.getAbsolutePath() + "'"));
        Properties tempApiKeys = new Properties();
        tempApiKeys.load(new FileReader(apiKeysFile));
        this.apiKeys = tempApiKeys;
        this.readUsedPublicKeys();
        this.initServer(port);
    }

    public Properties getApiKeys() {
        return this.apiKeys;
    }

    private void initServer(int port) throws IOException {
        this.kryoServer = new com.esotericsoftware.kryonet.Server();
        KryoCommon.registerClasses((Kryo)this.kryoServer.getKryo());
        this.kryoServer.bind(port);
        this.kryoServer.addListener(new Listener(){

            public void received(Connection connection, Object object) {
                Object response = Server.this.createResponse(object);
                if (response != null) {
                    connection.sendTCP(response);
                }
            }
        });
        this.kryoServer.start();
    }

    public Object createResponse(Object receivedObject) {
        try {
            if (receivedObject instanceof APIKeyRequest) {
                APIKeyRequest request = (APIKeyRequest)receivedObject;
                byte[] encodedPublicKey = request.getEncodedClientPublicKey();
                PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(encodedPublicKey));
                if (ListCommon.listContainsArray(this.usedKeys, (byte[])encodedPublicKey)) {
                    return new MultipleRequestsWithSameRSAKeyExceptionInternalImpl();
                }
                this.addUsedPublicKey(encodedPublicKey);
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(1, publicKey);
                Charset encoding = Charset.forName("UTF-8");
                return new APIKeyResponse(request.getRequestedApiKeyName(), cipher.doFinal(this.apiKeys.getProperty(request.getRequestedApiKeyName()).getBytes(encoding)), encoding.name());
            }
            return new BadRequestExceptionInternalImpl("Unknown object type");
        }
        catch (Exception e) {
            FOKLogger.log((String)Server.class.getName(), (Level)Level.SEVERE, (String)"Internal server exception", (Throwable)e);
            return new InternalServerExceptionInternalImpl(e.getMessage(), ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void addUsedPublicKey(byte[] encodedPublicKey) {
        this.usedKeys.add(encodedPublicKey);
        try {
            this.saveUsedPublicKeys();
        }
        catch (FileNotFoundException e) {
            FOKLogger.log((String)Server.class.getName(), (Level)Level.SEVERE, (String)"Could not save the used keys list", (Throwable)e);
        }
    }

    public void readUsedPublicKeys() {
        this.readUsedPublicKeys(Common.getInstance().getAndCreateAppDataPath() + FILE_NAME_FOR_USED_PUBLIC_KEYS);
    }

    public void readUsedPublicKeys(String filePath) {
        FOKLogger.info((String)Server.class.getName(), (String)("Trying to read the used public keys list from '" + filePath + "'..."));
        try (Input input = new Input((InputStream)new FileInputStream(filePath));){
            this.usedKeys = (ArrayList)this.getKryoToSaveUsedPublicKeys().readClassAndObject(input);
        }
        catch (KryoException | FileNotFoundException | ClassCastException | NullPointerException e) {
            FOKLogger.severe((String)Server.class.getName(), (String)("Unable to read the used public keys list from disk (" + e.getClass().getName() + "), initializing an empty list..."));
            File usedKeysFile = new File(filePath);
            if (usedKeysFile.exists()) {
                try {
                    Files.delete(usedKeysFile.toPath());
                }
                catch (IOException e1) {
                    FOKLogger.severe((String)Server.class.getName(), (String)("Unable to delete the old used public key list from the drive (" + e.getClass().getName() + "), the server will try to overwrite the file later..."));
                }
            }
            this.usedKeys = new ArrayList();
        }
    }

    public void saveUsedPublicKeys() throws FileNotFoundException {
        this.saveUsedPublicKeys(Common.getInstance().getAndCreateAppDataPath() + FILE_NAME_FOR_USED_PUBLIC_KEYS);
    }

    public void saveUsedPublicKeys(String filePath) throws FileNotFoundException {
        Output output = new Output((OutputStream)new FileOutputStream(filePath));
        this.getKryoToSaveUsedPublicKeys().writeClassAndObject(output, this.usedKeys);
        output.close();
    }

    private Kryo getKryoToSaveUsedPublicKeys() {
        Kryo kryo = new Kryo();
        kryo.register(ArrayList.class);
        kryo.register(byte[].class);
        kryo.setReferences(true);
        return kryo;
    }

    public boolean resetPermanently() {
        return this.resetPermanently(Common.getInstance().getAndCreateAppDataPath() + FILE_NAME_FOR_USED_PUBLIC_KEYS);
    }

    public boolean resetPermanently(String pathToUsedKeysFile) {
        File usedKeysFile = new File(pathToUsedKeysFile);
        if (usedKeysFile.exists()) {
            try {
                Files.delete(usedKeysFile.toPath());
            }
            catch (IOException e) {
                FOKLogger.log((String)Server.class.getName(), (Level)Level.SEVERE, (String)("Failed to delete the file '" + pathToUsedKeysFile + "', server will reset temporarily only."), (Throwable)e);
                this.resetTemporarily();
                return false;
            }
        }
        this.readUsedPublicKeys(pathToUsedKeysFile);
        return true;
    }

    public void resetTemporarily() {
        this.usedKeys = new ArrayList();
    }

    public void stop() {
        this.kryoServer.stop();
    }
}

