/*
 * Decompiled with CFR 0.152.
 */
package com.github.wiselenium.elements.component.impl;

import com.github.wiselenium.elements.component.MultiSelect;
import com.github.wiselenium.elements.component.Option;
import com.github.wiselenium.elements.component.impl.ComponentImpl;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;

public class MultiSelectImpl
extends ComponentImpl<MultiSelect>
implements MultiSelect {
    private Select wrappedSelect;
    @FindBy(tagName="option")
    private List<Option> options;

    @Override
    public MultiSelect deselectAll() {
        this.getWrappedSelect().deselectAll();
        return this;
    }

    @Override
    public MultiSelect deselectByIndex(int ... indexes) {
        for (int i : indexes) {
            this.getWrappedSelect().deselectByIndex(i);
        }
        return this;
    }

    @Override
    public MultiSelect deselectByValue(String ... values) {
        for (String v : values) {
            this.getWrappedSelect().deselectByValue(v);
        }
        return this;
    }

    @Override
    public MultiSelect deselectByVisibleText(String ... texts) {
        for (String t : texts) {
            this.getWrappedSelect().deselectByVisibleText(t);
        }
        return this;
    }

    @Override
    public MultiSelect deselectOptions(Option ... options) {
        for (Option option : options) {
            if (!option.isSelected()) continue;
            option.click();
        }
        return this;
    }

    @Override
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    public List<Option> getSelectedOptions() {
        ArrayList selectedOptions = Lists.newArrayList();
        for (Option option : this.options) {
            if (!option.isSelected()) continue;
            selectedOptions.add(option);
        }
        return selectedOptions;
    }

    @Override
    public List<String> getSelectedValues() {
        ArrayList values = Lists.newArrayList();
        List selectedOptions = this.getWrappedSelect().getAllSelectedOptions();
        for (WebElement option : selectedOptions) {
            values.add(option.getAttribute("value"));
        }
        return values;
    }

    @Override
    public List<String> getSelectedVisibleTexts() {
        ArrayList texts = Lists.newArrayList();
        List selectedOptions = this.getWrappedSelect().getAllSelectedOptions();
        for (WebElement option : selectedOptions) {
            texts.add(option.getText());
        }
        return texts;
    }

    @Override
    public MultiSelect selectAll() {
        List selectOptions = this.getWrappedSelect().getOptions();
        for (WebElement option : selectOptions) {
            if (option.isSelected()) continue;
            option.click();
        }
        return this;
    }

    @Override
    public MultiSelect selectByIndex(int ... indexes) {
        for (int i : indexes) {
            this.getWrappedSelect().selectByIndex(i);
        }
        return this;
    }

    @Override
    public MultiSelect selectByValue(String ... values) {
        for (String v : values) {
            this.getWrappedSelect().selectByValue(v);
        }
        return this;
    }

    @Override
    public MultiSelect selectByVisibleText(String ... texts) {
        for (String t : texts) {
            this.getWrappedSelect().selectByVisibleText(t);
        }
        return this;
    }

    @Override
    public MultiSelect selectOptions(Option ... options) {
        for (Option option : options) {
            if (option.isSelected()) continue;
            option.click();
        }
        return this;
    }

    private synchronized Select getWrappedSelect() {
        if (this.wrappedSelect == null) {
            this.wrappedSelect = new Select(this.getWrappedElement());
        }
        return this.wrappedSelect;
    }
}

