/*
 * Decompiled with CFR 0.152.
 */
package com.dltk.cntk;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.PointerByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class IEvaluateModelManaged<T>
implements AutoCloseable {
    protected Pointer eval = Pointer.NULL;

    public static void initializeCNTK(String cntkPath) {
        EvaluationCWrapper.INSTANCE.InitializeCNTK(new WString(cntkPath));
    }

    public static void initializeCNTK(File cntkDirectory) {
        IEvaluateModelManaged.initializeCNTK(cntkDirectory.getAbsolutePath());
    }

    public static void addLibraryDirectory(String path) {
        EvaluationCWrapper.INSTANCE.AddLibraryDirectory(new WString(path));
    }

    public static void addLibraryDirectory(File directory) {
        IEvaluateModelManaged.addLibraryDirectory(directory.getAbsolutePath());
    }

    public static void setWorkingDirectory(String path) {
        EvaluationCWrapper.INSTANCE.SetWorkingDirectory(path);
    }

    public static void setWorkingDirectory(File directory) {
        IEvaluateModelManaged.setWorkingDirectory(directory.getAbsolutePath());
    }

    public static String readConfiguration(File configFile) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            String line;
            while ((line = br.readLine()) != null) {
                builder.append(line + "\n");
            }
        }
        return builder.toString();
    }

    public IEvaluateModelManaged(@Nonnull String funcName) {
        PointerByReference pbr = new PointerByReference();
        switch (funcName) {
            case "GetEvalF": {
                EvaluationCWrapper.INSTANCE.GetEvalF(pbr);
                break;
            }
            case "GetEvalD": {
                EvaluationCWrapper.INSTANCE.GetEvalD(pbr);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.eval = pbr.getValue();
    }

    public abstract void init(@Nonnull String var1);

    public void init(@Nonnull File configurationFile) throws IOException {
        this.init(IEvaluateModelManaged.readConfiguration(configurationFile));
    }

    public void loadModel(@Nonnull String modelFileName) {
        this.loadModel(new WString(modelFileName));
    }

    public abstract void loadModel(@Nonnull WString var1);

    public abstract void evaluate(@Nonnull Map<WString, List<T>> var1, @Nonnull Map<WString, List<T>> var2);

    public abstract List<T> evaluate(@Nonnull Map<WString, List<T>> var1, @Nonnull WString var2, int var3);

    public static interface EvaluationCWrapper
    extends Library {
        public static final EvaluationCWrapper INSTANCE = (EvaluationCWrapper)Native.loadLibrary((String)"EvaluationCWrapper-1.0.dll", EvaluationCWrapper.class);

        public void InitializeCNTK(WString var1);

        public void AddLibraryDirectory(WString var1);

        public void SetWorkingDirectory(String var1);

        public void GetEvalF(PointerByReference var1);

        public void GetEvalD(PointerByReference var1);

        public void IEvaluateModelF_Destroy(Pointer var1);

        public void IEvaluateModelD_Destroy(Pointer var1);

        public void IEvaluateModelF_Init(Pointer var1, String var2);

        public void IEvaluateModelD_Init(Pointer var1, String var2);

        public void IEvaluateModelF_LoadModel(Pointer var1, WString var2);

        public void IEvaluateModelD_LoadModel(Pointer var1, WString var2);

        public void IEvaluateModelF_StartEvaluateMinibatchLoop(Pointer var1, WString var2);

        public void IEvaluateModelD_StartEvaluateMinibatchLoop(Pointer var1, WString var2);

        public void IEvaluateModelF_Evaluate(Pointer var1, Pointer var2, Pointer var3);

        public void IEvaluateModelD_Evaluate(Pointer var1, Pointer var2, Pointer var3);

        public void IEvaluateModelF_ResetState(Pointer var1);

        public void IEvaluateModelD_ResetState(Pointer var1);

        public Pointer CreateEmptyMapF(WString[] var1, int var2, Pointer var3);

        public Pointer CreateMapF(WString[] var1, int var2, Pointer var3, Pointer var4);

        public Pointer CreateEmptyMapD(WString[] var1, int var2, Pointer var3);

        public Pointer CreateMapD(WString[] var1, int var2, Pointer var3, Pointer var4);

        public void ReadMapF(Pointer var1, MapEntryReadF var2);

        public void ReadMapD(Pointer var1, MapEntryReadD var2);

        public void DisposeMapF(Pointer var1);

        public void DisposeMapD(Pointer var1);

        public static interface MapEntryReadD
        extends Callback {
            public void invoke(WString var1, Pointer var2, int var3);
        }

        public static interface MapEntryReadF
        extends Callback {
            public void invoke(WString var1, Pointer var2, int var3);
        }
    }
}

