/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.dynamicdatasource.datasource;

import com.github.yeecode.dynamicdatasource.DynamicDataSource;
import com.github.yeecode.dynamicdatasource.model.DataSourceInfo;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DynamicDataSourceConfig {
    @Value(value="${dynamicDataSource.default.url}")
    private String defaultUrl;
    @Value(value="${dynamicDataSource.default.driverClassName}")
    private String driverClassName;
    @Value(value="${dynamicDataSource.default.username}")
    private String defaultUsername;
    @Value(value="${dynamicDataSource.default.password}")
    private String defaultPassword;

    @Bean(value={"defaultDataSource"})
    public DataSource defaultDataSource() {
        return DataSourceBuilder.create().url(this.defaultUrl).driverClassName(this.driverClassName).username(this.defaultUsername).password(this.defaultPassword).build();
    }

    @Bean
    @Primary
    public DynamicDataSource dynamicDataSource(DataSource defaultDataSource) {
        return new DynamicDataSource(defaultDataSource);
    }

    public static DataSource createDataSource(DataSourceInfo datasourceInfo) {
        return DataSourceBuilder.create().url(datasourceInfo.getUrl()).driverClassName(datasourceInfo.getDriverClassName()).username(datasourceInfo.getUserName()).password(datasourceInfo.getPassword()).build();
    }
}

