/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.service;

import com.github.yeecode.objectLogger.client.config.ObjectLoggerConfigBean;
import com.github.yeecode.objectLogger.client.handler.BaseExtendedTypeHandler;
import com.github.yeecode.objectLogger.client.http.HttpBean;
import com.github.yeecode.objectLogger.client.model.ActionItemModel;
import com.github.yeecode.objectLogger.client.task.SendLogForItemsTask;
import com.github.yeecode.objectLogger.client.task.SendLogForObjectTask;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogClient {
    @Autowired
    private ObjectLoggerConfigBean objectLoggerConfigBean;
    @Autowired
    private HttpBean httpBean;
    @Autowired(required=false)
    private BaseExtendedTypeHandler baseExtendedTypeHandler;
    private ExecutorService fixedThreadPool = Executors.newFixedThreadPool(10);

    public void sendLogForObject(Integer objectId, String actor, String action, String actionName, String extraWords, String comment, Object oldObject, Object newObject) {
        try {
            SendLogForObjectTask sendLogForObjectTask = new SendLogForObjectTask(objectId, actor, action, actionName, extraWords, comment, oldObject, newObject, this.objectLoggerConfigBean, this.httpBean, this.baseExtendedTypeHandler);
            this.fixedThreadPool.execute(sendLogForObjectTask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendLogForItems(String objectName, Integer objectId, String actor, String action, String actionName, String extraWords, String comment, List<ActionItemModel> actionItemModelList) {
        try {
            SendLogForItemsTask sendLogForItemsTask = new SendLogForItemsTask(objectName, objectId, actor, action, actionName, extraWords, comment, actionItemModelList, this.objectLoggerConfigBean, this.httpBean);
            this.fixedThreadPool.execute(sendLogForItemsTask);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

