/*
 * Decompiled with CFR 0.152.
 */
package com.github.yeecode.objectLogger.client.task;

import com.alibaba.fastjson.JSON;
import com.github.yeecode.objectLogger.client.config.ObjectLoggerConfigBean;
import com.github.yeecode.objectLogger.client.http.HttpBean;
import com.github.yeecode.objectLogger.client.model.ActionItemModel;
import com.github.yeecode.objectLogger.client.model.ActionModel;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class SendLogForItemsTask
implements Runnable {
    private HttpBean httpBean;
    private String objectName;
    private Integer objectId;
    private String actor;
    private String action;
    private String actionName;
    private String extraWords;
    private String comment;
    private ObjectLoggerConfigBean objectLoggerConfigBean;
    private List<ActionItemModel> actionItemModelList;

    public SendLogForItemsTask(String objectName, Integer objectId, String actor, String action, String actionName, String extraWords, String comment, List<ActionItemModel> actionItemModelList, ObjectLoggerConfigBean objectLoggerConfigBean, HttpBean httpBean) {
        this.objectName = objectName;
        this.objectId = objectId;
        this.actor = actor;
        this.action = action;
        this.actionName = actionName;
        this.extraWords = extraWords;
        this.comment = comment;
        this.actionItemModelList = actionItemModelList;
        this.objectLoggerConfigBean = objectLoggerConfigBean;
        this.httpBean = httpBean;
    }

    @Override
    public void run() {
        try {
            ActionModel actionModel = new ActionModel(this.objectLoggerConfigBean.getAppName(), this.objectName, this.objectId, this.actor, this.action, this.actionName, this.extraWords, this.comment, new Date());
            if (!CollectionUtils.isEmpty(this.actionItemModelList)) {
                actionModel.getActionItemModelList().addAll(this.actionItemModelList);
            }
            this.httpBean.sendLog(JSON.toJSONString((Object)actionModel));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

