package cdc.issues.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import cdc.issues.Params;
import cdc.issues.rules.Profile;
import cdc.issues.rules.Rule;
import cdc.util.lang.Checks;

public class ProfileImpl implements Profile {
    private String name;
    private final Map<Rule, Params> rules = new HashMap<>();

    public ProfileImpl(String name) {
        this.name = name;
    }

    public ProfileImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return name;
    }

    public ProfileImpl enableRule(Rule rule,
                                     Params params) {
        Checks.isNotNull(rule, "rule");
        Checks.isNotNull(params, "params");

        rules.put(rule, params);
        return this;
    }

    public ProfileImpl enableRule(Rule rule) {
        return enableRule(rule, Params.NO_PARAMS);
    }

    public ProfileImpl disableRule(Rule rule) {
        Checks.isNotNull(rule, "rule");

        rules.remove(rule);
        return this;
    }

    @Override
    public Set<Rule> getEnabledRules() {
        return rules.keySet();
    }

    @Override
    public Params getRuleParams(Rule rule) {
        return rules.get(rule);
    }
}