package cdc.issues.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

import cdc.issues.Issue;
import cdc.issues.Snapshot;
import cdc.util.lang.Checks;

public class SnapshotImpl implements Snapshot {
    private String name;
    private Instant timestamp;
    private final List<Issue> issues = new ArrayList<>();

    public SnapshotImpl() {
        this(null);
    }

    public SnapshotImpl(String name) {
        this(name, Instant.now());
    }

    public SnapshotImpl(String name,
                        Instant timestamp) {
        this.name = name;
        this.timestamp = timestamp;
    }

    public SnapshotImpl setName(String name) {
        this.name = name;
        return this;
    }

    public SnapshotImpl setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public SnapshotImpl addIssue(Issue issue) {
        Checks.isNotNull(issue, "issue");
        issues.add(issue);
        return this;
    }

    public SnapshotImpl addIssues(List<? extends Issue> issues) {
        this.issues.addAll(issues);
        return this;
    }

    @Override
    public Instant getTimestamp() {
        return timestamp;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public List<Issue> getIssues() {
        return issues;
    }
}