package cdc.issues.impl;

import java.time.Instant;
import java.util.Optional;

import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.io.SnapshotData;
import cdc.issues.rules.Profile;

public class SnapshotDataImpl implements SnapshotData {
    private String projectName;
    private Profile profile;
    private String snapshotName;
    private Instant snapshotTimestamp = Instant.now();
    private int numberOfIssues = -1;

    public SnapshotDataImpl() {
        super();
    }

    public SnapshotDataImpl(Snapshot snapshot) {
        final Project project = snapshot.getProject().orElse(null);
        setProjectName(project == null ? null : project.getName());
        setProfile(project == null ? null : project.getProfile().orElse(null));
        setSnapshotName(snapshot.getName());
        setSnapshotTimestamp(snapshot.getTimestamp());
    }

    public SnapshotDataImpl setProjectName(String name) {
        this.projectName = name;
        return this;
    }

    public SnapshotDataImpl setProfile(Profile profile) {
        this.profile = profile;
        return this;
    }

    public SnapshotDataImpl setSnapshotName(String name) {
        this.snapshotName = name;
        return this;
    }

    public SnapshotDataImpl setSnapshotTimestamp(Instant timestamp) {
        this.snapshotTimestamp = timestamp;
        return this;
    }

    public SnapshotDataImpl setNulberOfIssues(int number) {
        this.numberOfIssues = number;
        return this;
    }

    @Override
    public String getProjectName() {
        return projectName;
    }

    @Override
    public Optional<? extends Profile> getProfile() {
        return Optional.ofNullable(profile);
    }

    @Override
    public String getSnapshotName() {
        return snapshotName;
    }

    @Override
    public Instant getSnapshotTimestamp() {
        return snapshotTimestamp;
    }

    @Override
    public int getNumberOfIssues() {
        return numberOfIssues;
    }
}