/*
 * Decompiled with CFR 0.152.
 */
package cdc.args.io;

import cdc.args.Arg;
import cdc.args.Args;
import cdc.args.Factories;
import cdc.args.Factory;
import cdc.io.data.Child;
import cdc.io.data.Element;
import cdc.io.data.util.AbstractResourceLoader;
import cdc.io.xml.AbstractStAXLoader;
import cdc.io.xml.AbstractStAXParser;
import cdc.io.xml.XmlWriter;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class ArgsIo {
    public static final String ARG = "arg";
    public static final String ARGS = "args";
    public static final String CLASS = "class";
    public static final String FACTORIES = "factories";
    public static final String FACTORY = "factory";
    public static final String INSTANCE = "instance";
    public static final String NAME = "name";
    public static final String PARAM = "param";
    public static final String PARAMS = "params";
    public static final String VALUE = "value";
    public static final ArgsIo ARG_NAMING = new ArgsIo(Naming.ARG);
    public static final ArgsIo PARAM_NAMING = new ArgsIo(Naming.PARAM);
    private final Naming naming;

    public ArgsIo(Naming naming) {
        this.naming = naming;
    }

    private String argName() {
        return this.naming == Naming.ARG ? ARG : PARAM;
    }

    private String argsName() {
        return this.naming == Naming.ARG ? ARGS : PARAMS;
    }

    public void write(XmlWriter writer, Args args, boolean convert) throws IOException {
        if (!args.isEmpty()) {
            writer.beginElement(this.argsName());
            for (Arg arg : args.getArgs()) {
                this.write(writer, arg, convert);
            }
            writer.endElement();
        }
    }

    public void write(XmlWriter writer, Arg arg, boolean convert) throws IOException {
        if (arg.getValue() == null) {
            writer.beginElement(this.argName());
            writer.addAttribute(NAME, arg.getName());
            writer.endElement();
        } else {
            Arg tmp = convert ? Factories.convertToStringValues((Arg)arg) : arg;
            writer.beginElement(this.argName());
            writer.addAttribute(NAME, tmp.getName());
            if (tmp.getValue() != null) {
                writer.addAttribute(VALUE, tmp.getValue());
            }
            writer.endElement();
        }
    }

    public Element toElement(Args args, boolean convert) {
        if (!args.isEmpty()) {
            Element element = new Element(this.argsName());
            for (Arg arg : args.getArgs()) {
                element.addChild((Child)this.toElement(arg, convert));
            }
            return element;
        }
        return null;
    }

    public Element toElement(Arg arg, boolean convert) {
        Element element = new Element(this.argName());
        element.addAttribute(NAME, arg.getName());
        if (arg.getValue() != null) {
            Arg tmp;
            Arg arg2 = tmp = convert ? Factories.convertToStringValues((Arg)arg) : arg;
            if (tmp.getValue() != null) {
                element.addAttribute(VALUE, tmp.getValue());
            }
        }
        return element;
    }

    public static enum Naming {
        ARG,
        PARAM;

    }

    public static class StAXLoader
    extends AbstractStAXLoader<Void> {
        public StAXLoader(FailureReaction reaction) {
            super((reader, systemId) -> new Parser((XMLStreamReader)reader, (String)systemId, reaction));
        }

        private static class Parser
        extends AbstractStAXParser<Void> {
            protected Parser(XMLStreamReader reader, String systemId, FailureReaction reaction) {
                super(reader, systemId, reaction);
            }

            protected Void parse() throws XMLStreamException {
                this.nextTag();
                if (this.isStartElement(ArgsIo.FACTORIES)) {
                    this.parseFactories();
                    this.next();
                    this.expectEndDocument("parse()");
                    return null;
                }
                throw this.unexpectedEvent();
            }

            private void parseFactories() throws XMLStreamException {
                this.nextTag();
                while (this.reader.isStartElement()) {
                    if (!this.isStartElement(ArgsIo.FACTORY)) {
                        throw this.unexpectedEvent();
                    }
                    this.parseAndRegisterFactory();
                    this.nextTag();
                }
            }

            private void parseAndRegisterFactory() throws XMLStreamException {
                Factory<?> factory = this.parseFactory();
                if (factory != null) {
                    if (Factories.getClasses().contains(factory.getObjectClass())) {
                        this.onError("A '" + factory.getObjectClass().getCanonicalName() + "' factory is already registered");
                    } else {
                        Factories.register(factory);
                    }
                }
            }

            private Factory<?> parseFactory() throws XMLStreamException {
                String className = this.getAttributeValue(ArgsIo.CLASS, null);
                String instanceName = this.getAttributeValue(ArgsIo.INSTANCE, null);
                Factory factory = null;
                if (className == null && instanceName == null || className != null && instanceName != null) {
                    factory = (Factory)this.onError("one of class or instance attribute must be set", null);
                } else if (className != null) {
                    Class cls = Introspection.getClass((String)className, (FailureReaction)this.getReaction());
                    if (cls != null) {
                        try {
                            factory = (Factory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            factory = (Factory)this.onError("Failed to instantiate '" + className + "'", null);
                        }
                    }
                } else {
                    factory = (Factory)this.onError("instance support not yet implemented", null);
                }
                this.nextTag();
                this.expectEndElement("parseFactory()", ArgsIo.FACTORY);
                return factory;
            }
        }
    }

    public static class ArgsParser
    extends AbstractStAXParser<Void> {
        public ArgsParser(XMLStreamReader reader, String systemId, FailureReaction reaction) {
            super(reader, systemId, reaction);
        }

        protected Void parse() {
            throw new UnsupportedOperationException();
        }

        public Args parseArgs() throws XMLStreamException {
            this.expectStartElement("parseArgs()", new String[]{ArgsIo.ARGS, ArgsIo.PARAMS});
            Args.Builder builder = Args.builder();
            this.nextTag();
            while (this.isStartElement(ArgsIo.ARG) || this.isStartElement(ArgsIo.PARAM)) {
                String argName = this.getAttributeValue(ArgsIo.NAME, null);
                String argValue = this.getAttributeValue(ArgsIo.VALUE, null);
                builder.arg(argName, (Object)argValue);
                this.nextTag();
                this.expectEndElement("parseArgs()", new String[]{ArgsIo.ARG, ArgsIo.PARAM});
                this.nextTag();
            }
            this.expectEndElement("parseArgs()", new String[]{ArgsIo.ARGS, ArgsIo.PARAMS});
            return builder.build();
        }
    }

    public static class DataLoader
    extends AbstractResourceLoader<Void> {
        public DataLoader(FailureReaction reaction) {
            super(reaction);
        }

        protected Void loadRoot(Element root) {
            this.loadAndRegisterFactories(root);
            return null;
        }

        public void loadAndRegisterFactories(Element element) {
            if (element.getName().equals(ArgsIo.FACTORIES)) {
                for (Element child : element.getElements()) {
                    if (child.getName().equals(ArgsIo.FACTORY)) {
                        this.loadAndRegisterFactory(child);
                        continue;
                    }
                    this.unexpectedElement(child, new String[]{ArgsIo.FACTORY});
                }
            } else {
                this.unexpectedElement(element, new String[]{ArgsIo.FACTORIES});
            }
        }

        public void loadAndRegisterFactory(Element element) {
            Factory<?> factory = this.loadFactory(element);
            if (factory != null) {
                if (Factories.getClasses().contains(factory.getObjectClass())) {
                    this.onError("A '" + factory.getObjectClass().getCanonicalName() + "' factory is already registered");
                } else {
                    Factories.register(factory);
                }
            }
        }

        public Factory<?> loadFactory(Element element) {
            if (element.getName().equals(ArgsIo.FACTORY)) {
                String className = element.getAttributeValue(ArgsIo.CLASS, null);
                String instanceName = element.getAttributeValue(ArgsIo.INSTANCE, null);
                if (className == null && instanceName == null || className != null && instanceName != null) {
                    return (Factory)this.onError("one of class or instance attribute must be set", null);
                }
                if (className != null) {
                    Class cls = Introspection.getClass((String)className, (FailureReaction)this.getReaction());
                    if (cls != null) {
                        try {
                            return (Factory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            return (Factory)this.onError("Failed to instantiate '" + className + "'", null);
                        }
                    }
                    return null;
                }
                return (Factory)this.onError("instance support not yet implemented", null);
            }
            return (Factory)this.unexpectedElement(element, null, new String[]{ArgsIo.FACTORY});
        }

        public Args loadArgs(Element element) {
            if (element.getName().equals(ArgsIo.ARGS) || element.getName().equals(ArgsIo.PARAMS)) {
                Args.Builder builder = Args.builder();
                for (Element child : element.getElements()) {
                    if (child.getName().equals(ArgsIo.ARG) || child.getName().equals(ArgsIo.PARAM)) {
                        String argName = child.getAttributeValue(ArgsIo.NAME, null);
                        String argValue = child.getAttributeValue(ArgsIo.VALUE, null);
                        builder.arg(argName, (Object)argValue);
                        continue;
                    }
                    this.unexpectedElement(child, new String[]{ArgsIo.ARG, ArgsIo.PARAM});
                }
                return builder.build();
            }
            return (Args)this.unexpectedElement(element, Args.NO_ARGS, new String[]{ArgsIo.ARGS, ArgsIo.PARAMS});
        }

        public static Args toArgsLoose(Element element) {
            Args.Builder builder = Args.builder();
            for (Element child : element.getElements()) {
                if (!child.getName().equals(ArgsIo.ARG) && !child.getName().equals(ArgsIo.PARAM)) continue;
                String argName = child.getAttributeValue(ArgsIo.NAME, null);
                String argValue = child.getAttributeValue(ArgsIo.VALUE, null);
                builder.arg(argName, (Object)argValue);
            }
            return builder.build();
        }

        public Args loadOptionalChildArgs(Element parent) {
            if (parent.hasChildren(Element.class, Element.named((String)ArgsIo.ARGS))) {
                return this.loadArgs((Element)parent.getChildAt(Element.class, Element.named((String)ArgsIo.ARGS), 0));
            }
            if (parent.hasChildren(Element.class, Element.named((String)ArgsIo.PARAMS))) {
                return this.loadArgs((Element)parent.getChildAt(Element.class, Element.named((String)ArgsIo.PARAMS), 0));
            }
            return Args.NO_ARGS;
        }
    }
}

