/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.AttachmentMedia;
import com.google.code.facebookapi.AttachmentProperty;
import com.google.code.facebookapi.BasicClientHelper;
import com.google.code.facebookapi.ToJsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attachment
implements Serializable,
ToJsonObject {
    private String name;
    private String href;
    private String caption;
    private String description;
    private List<AttachmentProperty> properties;
    private List<AttachmentMedia> media;
    private Map<String, String> additionalInfo;
    private JSONObject tojson;

    @Override
    public JSONObject toJson() {
        this.tojson = new JSONObject();
        Attachment.putQuiet("name", this.name, this.tojson);
        Attachment.putQuiet("href", this.href, this.tojson);
        Attachment.putQuiet("caption", this.caption, this.tojson);
        Attachment.putQuiet("description", this.description, this.tojson);
        this.putProperties(this.tojson);
        this.putMedia(this.tojson);
        this.putAdditionalInfo(this.tojson);
        return this.tojson;
    }

    private static void putQuiet(String key, Object value, JSONObject json) {
        if (value != null) {
            try {
                json.put(key, value);
            }
            catch (JSONException ex) {
                throw BasicClientHelper.runtimeException((Exception)((Object)ex));
            }
        }
    }

    private void putProperties(JSONObject tojson) {
        if (this.properties == null || this.properties.isEmpty()) {
            return;
        }
        JSONObject jsonProperties = new JSONObject();
        for (AttachmentProperty link : this.properties) {
            try {
                if (!StringUtils.isEmpty((String)link.getHref())) {
                    JSONObject val = new JSONObject();
                    val.put("text", (Object)link.getValue());
                    val.put("href", (Object)link.getHref());
                    jsonProperties.put(link.getKey(), (Object)val);
                    continue;
                }
                jsonProperties.put(link.getKey(), (Object)link.getValue());
            }
            catch (JSONException exception) {
                throw BasicClientHelper.runtimeException((Exception)((Object)exception));
            }
        }
        Attachment.putQuiet("properties", jsonProperties, tojson);
    }

    private void putMedia(JSONObject tojson) {
        if (this.media == null || this.media.isEmpty()) {
            return;
        }
        JSONArray ar = new JSONArray();
        for (AttachmentMedia m : this.media) {
            ar.put((Object)m.toJson());
        }
        Attachment.putQuiet("media", ar, tojson);
    }

    private void putAdditionalInfo(JSONObject tojson) {
        if (this.additionalInfo == null || this.additionalInfo.isEmpty()) {
            return;
        }
        for (String key : this.additionalInfo.keySet()) {
            Attachment.putQuiet(key, this.additionalInfo.get(key), tojson);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<AttachmentProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<AttachmentProperty> properties) {
        this.properties = properties;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public List<AttachmentMedia> getMedia() {
        return this.media;
    }

    public void setMedia(List<AttachmentMedia> media) {
        this.media = media;
    }

    public void setMedia(AttachmentMedia media) {
        this.media = new ArrayList<AttachmentMedia>();
        this.media.add(media);
    }

    public void addMedia(AttachmentMedia media) {
        if (this.media == null) {
            this.media = new ArrayList<AttachmentMedia>();
        }
        this.media.add(media);
    }
}

