/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.BasicClientHelper;
import com.google.code.facebookapi.ExtensibleClient;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.SpecificReturnTypeAdapter;
import com.google.code.facebookapi.XmlHelper;
import com.google.code.facebookapi.schema.FacebookApiException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacebookJaxbRestClientBase
extends SpecificReturnTypeAdapter<Object> {
    protected static Log log = LogFactory.getLog(FacebookJaxbRestClientBase.class);
    protected static JAXBContext JAXB_CONTEXT;

    public FacebookJaxbRestClientBase(ExtensibleClient client) {
        super("xml", client);
        FacebookJaxbRestClientBase.initJaxbSupport();
    }

    public FacebookJaxbRestClientBase(String apiKey, String secret) {
        this(new ExtensibleClient("xml", apiKey, secret));
    }

    public FacebookJaxbRestClientBase(String apiKey, String secret, String sessionKey) {
        this(new ExtensibleClient("xml", apiKey, secret, sessionKey));
    }

    public FacebookJaxbRestClientBase(String apiKey, String secret, String sessionKey, boolean sessionSecret) {
        this(new ExtensibleClient("xml", apiKey, secret, sessionKey, sessionSecret));
    }

    public JAXBContext getJaxbContext() {
        return JAXB_CONTEXT;
    }

    public void setJaxbContext(JAXBContext context) {
        JAXB_CONTEXT = context;
    }

    public static void initJaxbSupport() {
        if (JAXB_CONTEXT == null) {
            try {
                JAXB_CONTEXT = JAXBContext.newInstance((String)"com.google.code.facebookapi.schema");
            }
            catch (JAXBException ex) {
                log.error((Object)("MalformedURLException: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public Object getResponsePOJO() {
        return this.getResponsePOJO(this.getRawResponse());
    }

    public Object getResponsePOJO(String rawResponse) {
        if (JAXB_CONTEXT == null) {
            return null;
        }
        try {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            return unmarshaller.unmarshal((Reader)new StringReader(rawResponse));
        }
        catch (Exception ex) {
            throw BasicClientHelper.runtimeException(ex);
        }
    }

    protected Object parseCallResult(Object rawResponse) throws FacebookException {
        if (rawResponse == null) {
            return null;
        }
        log.debug((Object)("Facebook response:  " + rawResponse));
        Object out = this.getResponsePOJO((String)rawResponse);
        if (out instanceof JAXBElement) {
            JAXBElement jbe = (JAXBElement)out;
            out = jbe.getValue();
        }
        if (out instanceof FacebookApiException) {
            FacebookApiException error = (FacebookApiException)out;
            int errorCode = error.getErrorCode();
            String message = error.getErrorMsg();
            throw new FacebookException(errorCode, message);
        }
        return out;
    }

    @Override
    public List<? extends Object> executeBatch(boolean serial) throws FacebookException {
        List<String> clientResults = this.client.executeBatch(serial);
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            for (String clientResult : clientResults) {
                Document doc = builder.parse(new InputSource(new StringReader(clientResult)));
                NodeList responses = doc.getElementsByTagName("batch_run_response_elt");
                for (int count = 0; count < responses.getLength(); ++count) {
                    String response = XmlHelper.extractString(responses.item(count));
                    try {
                        Object pojo = this.parseCallResult(response);
                        result.add(pojo);
                        continue;
                    }
                    catch (Exception e) {
                        result.add(null);
                    }
                }
            }
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Error parsing batch response", ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException("Error parsing batch response", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error parsing batch response", ex);
        }
        return result;
    }
}

