/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.ItemClick;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ItemClickProcessor
implements DecoratingElementProcessor {
    private IdAnnotationHelper helper;

    public ItemClickProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return ItemClick.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        EBeansHolder.Classes classes = holder.classes();
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean hasItemParameter = parameters.size() == 1;
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, IRClass.Res.ID, true);
        JDefinedClass onItemClickListenerAnonymousClass = codeModel.anonymousClass(classes.ON_ITEM_CLICK_LISTENER);
        JMethod onItemClickMethod = onItemClickListenerAnonymousClass.method(1, codeModel.VOID, "onItemClick");
        onItemClickMethod.annotate(Override.class);
        JClass narrowAdapterViewClass = classes.ADAPTER_VIEW.narrow(codeModel.wildcard());
        JVar onItemClickParentParam = onItemClickMethod.param(narrowAdapterViewClass, "parent");
        onItemClickMethod.param(classes.VIEW, "view");
        JVar onItemClickPositionParam = onItemClickMethod.param(codeModel.INT, "position");
        onItemClickMethod.param(codeModel.LONG, "id");
        JInvocation itemClickCall = onItemClickMethod.body().invoke(methodName);
        if (hasItemParameter) {
            VariableElement parameter = parameters.get(0);
            TypeMirror parameterType = parameter.asType();
            if (parameterType.getKind() == TypeKind.INT) {
                itemClickCall.arg(onItemClickPositionParam);
            } else {
                String parameterTypeQualifiedName = ((Object)parameterType).toString();
                itemClickCall.arg(JExpr.cast(holder.refClass(parameterTypeQualifiedName), JExpr.invoke((JExpression)onItemClickParentParam, "getAdapter").invoke("getItem").arg(onItemClickPositionParam)));
            }
        }
        for (JFieldRef idRef : idsRefs) {
            JBlock block = holder.afterSetContentView.body().block();
            JInvocation findViewById = JExpr.invoke("findViewById");
            JVar view = block.decl(narrowAdapterViewClass, "view", JExpr.cast(narrowAdapterViewClass, findViewById.arg(idRef)));
            block._if(view.ne(JExpr._null()))._then().invoke((JExpression)view, "setOnItemClickListener").arg(JExpr._new(onItemClickListenerAnonymousClass));
        }
    }
}

