/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.RootContext;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class RootContextProcessor
implements DecoratingElementProcessor {
    @Override
    public Class<? extends Annotation> getTarget() {
        return RootContext.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror elementType = element.asType();
        String typeQualifiedName = ((Object)elementType).toString();
        JBlock body = holder.init.body();
        if ("android.content.Context".equals(typeQualifiedName)) {
            body.assign(JExpr.ref(fieldName), holder.contextRef);
        } else {
            JClass extendingContextClass = holder.refClass(typeQualifiedName);
            body._if(holder.contextRef._instanceof(extendingContextClass))._then().assign(JExpr.ref(fieldName), JExpr.cast(extendingContextClass, holder.contextRef));
        }
    }
}

