/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultBoolean;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultFloat;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultInt;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultLong;
import com.googlecode.androidannotations.annotations.sharedpreferences.DefaultString;
import com.googlecode.androidannotations.annotations.sharedpreferences.SharedPref;
import com.googlecode.androidannotations.api.sharedpreferences.BooleanPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.BooleanPrefField;
import com.googlecode.androidannotations.api.sharedpreferences.EditorHelper;
import com.googlecode.androidannotations.api.sharedpreferences.FloatPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.FloatPrefField;
import com.googlecode.androidannotations.api.sharedpreferences.IntPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.IntPrefField;
import com.googlecode.androidannotations.api.sharedpreferences.LongPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.LongPrefField;
import com.googlecode.androidannotations.api.sharedpreferences.SharedPreferencesHelper;
import com.googlecode.androidannotations.api.sharedpreferences.StringPrefEditorField;
import com.googlecode.androidannotations.api.sharedpreferences.StringPrefField;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.processing.GeneratingElementProcessor;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class SharedPrefProcessor
implements GeneratingElementProcessor {
    private static final Map<String, EditorFieldHolder> EDITOR_FIELD_BY_TYPE = new HashMap<String, EditorFieldHolder>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("boolean", new EditorFieldHolder(BooleanPrefEditorField.class, "booleanField"));
            this.put("float", new EditorFieldHolder(FloatPrefEditorField.class, "floatField"));
            this.put("int", new EditorFieldHolder(IntPrefEditorField.class, "intField"));
            this.put("long", new EditorFieldHolder(LongPrefEditorField.class, "longField"));
            this.put("java.lang.String", new EditorFieldHolder(StringPrefEditorField.class, "stringField"));
        }
    };

    @Override
    public Class<? extends Annotation> getTarget() {
        return SharedPref.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeansHolder eBeansHolder) throws Exception {
        TypeElement typeElement = (TypeElement)element;
        String interfaceQualifiedName = typeElement.getQualifiedName().toString();
        String interfaceSimpleName = typeElement.getSimpleName().toString();
        String helperQualifiedName = interfaceQualifiedName + "_";
        JDefinedClass helperClass = codeModel._class(9, helperQualifiedName, ClassType.CLASS);
        eBeansHolder.create(typeElement, this.getTarget(), helperClass);
        helperClass._extends(SharedPreferencesHelper.class);
        List<? extends Element> members = typeElement.getEnclosedElements();
        List<ExecutableElement> methods = ElementFilter.methodsIn(members);
        ArrayList<ExecutableElement> validMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : methods) {
            validMethods.add(method);
        }
        JDefinedClass editorClass = helperClass._class(25, interfaceSimpleName + "Editor" + "_");
        editorClass._extends(eBeansHolder.refClass(EditorHelper.class).narrow((JClass)editorClass));
        JMethod editorConstructor = editorClass.constructor(0);
        JClass sharedPreferencesClass = eBeansHolder.refClass("android.content.SharedPreferences");
        JVar sharedPreferencesParam = editorConstructor.param(sharedPreferencesClass, "sharedPreferences");
        editorConstructor.body().invoke("super").arg(sharedPreferencesParam);
        for (ExecutableElement method : validMethods) {
            String returnType = ((Object)method.getReturnType()).toString();
            EditorFieldHolder editorFieldHolder = EDITOR_FIELD_BY_TYPE.get(returnType);
            JClass editorFieldClass = eBeansHolder.refClass(editorFieldHolder.fieldClass);
            String fieldName = method.getSimpleName().toString();
            JMethod editorFieldMethod = editorClass.method(1, editorFieldClass.narrow((JClass)editorClass), fieldName);
            editorFieldMethod.body()._return(JExpr.invoke(editorFieldHolder.fieldMethodName).arg(fieldName));
        }
        JClass contextClass = eBeansHolder.refClass("android.content.Context");
        SharedPref sharedPrefAnnotation = typeElement.getAnnotation(SharedPref.class);
        SharedPref.Scope scope = sharedPrefAnnotation.value();
        int mode = sharedPrefAnnotation.mode();
        JMethod constructor = helperClass.constructor(1);
        switch (scope) {
            case ACTIVITY_DEFAULT: {
                JVar contextParam = constructor.param(contextClass, "context");
                JMethod getLocalClassName = this.getLocalClassName(eBeansHolder, helperClass, codeModel);
                constructor.body().invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.invoke(getLocalClassName).arg(contextParam)).arg(JExpr.lit(mode)));
                break;
            }
            case ACTIVITY: {
                JVar contextParam = constructor.param(contextClass, "context");
                JMethod getLocalClassName = this.getLocalClassName(eBeansHolder, helperClass, codeModel);
                constructor.body().invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.invoke(getLocalClassName).arg(contextParam).plus(JExpr.lit("_" + interfaceSimpleName))).arg(JExpr.lit(mode)));
                break;
            }
            case UNIQUE: {
                JVar contextParam = constructor.param(contextClass, "context");
                constructor.body().invoke("super").arg(contextParam.invoke("getSharedPreferences").arg(JExpr.lit(interfaceSimpleName)).arg(JExpr.lit(mode)));
                break;
            }
            case APPLICATION_DEFAULT: {
                JClass preferenceManagerClass = eBeansHolder.refClass("android.preference.PreferenceManager");
                JVar contextParam = constructor.param(contextClass, "context");
                constructor.body().invoke("super").arg(preferenceManagerClass.staticInvoke("getDefaultSharedPreferences").arg(contextParam));
                break;
            }
        }
        JMethod editMethod = helperClass.method(1, editorClass, "edit");
        editMethod.body()._return(JExpr._new(editorClass).arg(JExpr.invoke("getSharedPreferences")));
        for (ExecutableElement method : validMethods) {
            JExpression defaultValue;
            Annotation defaultAnnotation;
            String returnType = ((Object)method.getReturnType()).toString();
            String fieldName = method.getSimpleName().toString();
            if ("boolean".equals(returnType)) {
                defaultAnnotation = method.getAnnotation(DefaultBoolean.class);
                defaultValue = defaultAnnotation != null ? JExpr.lit(defaultAnnotation.value()) : JExpr.lit(false);
                this.addFieldHelperMethod(helperClass, fieldName, defaultValue, BooleanPrefField.class, "booleanField");
                continue;
            }
            if ("float".equals(returnType)) {
                defaultAnnotation = method.getAnnotation(DefaultFloat.class);
                defaultValue = defaultAnnotation != null ? JExpr.lit(defaultAnnotation.value()) : JExpr.lit(0.0f);
                this.addFieldHelperMethod(helperClass, fieldName, defaultValue, FloatPrefField.class, "floatField");
                continue;
            }
            if ("int".equals(returnType)) {
                defaultAnnotation = method.getAnnotation(DefaultInt.class);
                defaultValue = defaultAnnotation != null ? JExpr.lit(defaultAnnotation.value()) : JExpr.lit(0);
                this.addFieldHelperMethod(helperClass, fieldName, defaultValue, IntPrefField.class, "intField");
                continue;
            }
            if ("long".equals(returnType)) {
                defaultAnnotation = method.getAnnotation(DefaultLong.class);
                defaultValue = defaultAnnotation != null ? JExpr.lit(defaultAnnotation.value()) : JExpr.lit(0L);
                this.addFieldHelperMethod(helperClass, fieldName, defaultValue, LongPrefField.class, "longField");
                continue;
            }
            if (!"java.lang.String".equals(returnType)) continue;
            defaultAnnotation = method.getAnnotation(DefaultString.class);
            defaultValue = defaultAnnotation != null ? JExpr.lit(defaultAnnotation.value()) : JExpr.lit("");
            this.addFieldHelperMethod(helperClass, fieldName, defaultValue, StringPrefField.class, "stringField");
        }
    }

    private void addFieldHelperMethod(JDefinedClass helperClass, String fieldName, JExpression defaultValue, Class<?> prefFieldHelperClass, String fieldHelperMethodName) {
        JMethod fieldMethod = helperClass.method(1, prefFieldHelperClass, fieldName);
        fieldMethod.body()._return(JExpr.invoke(fieldHelperMethodName).arg(fieldName).arg(defaultValue));
    }

    private JMethod getLocalClassName(EBeansHolder eBeansHolder, JDefinedClass helperClass, JCodeModel codeModel) {
        JClass stringClass = eBeansHolder.refClass(String.class);
        JMethod getLocalClassName = helperClass.method(20, stringClass, "getLocalClassName");
        JClass contextClass = eBeansHolder.refClass("android.content.Context");
        JVar contextParam = getLocalClassName.param(contextClass, "context");
        JBlock body = getLocalClassName.body();
        JVar packageName = body.decl(stringClass, "packageName", contextParam.invoke("getPackageName"));
        JVar className = body.decl(stringClass, "className", contextParam.invoke("getClass").invoke("getName"));
        JVar packageLen = body.decl(codeModel.INT, "packageLen", packageName.invoke("length"));
        JExpression condition = className.invoke("startsWith").arg(packageName).not().cor(className.invoke("length").lte(packageLen)).cor(className.invoke("charAt").arg(packageLen).ne(JExpr.lit('.')));
        body._if(condition)._then()._return(className);
        body._return(className.invoke("substring").arg(packageLen.plus(JExpr.lit(1))));
        return getLocalClassName;
    }

    private static class EditorFieldHolder {
        public final Class<?> fieldClass;
        public final String fieldMethodName;

        public EditorFieldHolder(Class<?> fieldClass, String fieldMethodName) {
            this.fieldClass = fieldClass;
            this.fieldMethodName = fieldMethodName;
        }
    }
}

