/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.rclass;

import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.rclass.IRInnerClass;
import com.googlecode.androidannotations.rclass.RInnerClass;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public class RClass
implements IRClass {
    private final Map<String, RInnerClass> rClass = new HashMap<String, RInnerClass>();

    public RClass(TypeElement rClassElement) {
        List<TypeElement> rInnerTypeElements = this.extractRInnerTypeElements(rClassElement);
        for (TypeElement rInnerTypeElement : rInnerTypeElements) {
            RInnerClass rInnerClass = new RInnerClass(rInnerTypeElement);
            this.rClass.put(rInnerTypeElement.getSimpleName().toString(), rInnerClass);
        }
    }

    private List<TypeElement> extractRInnerTypeElements(TypeElement rClassElement) {
        List<? extends Element> rEnclosedElements = rClassElement.getEnclosedElements();
        return ElementFilter.typesIn(rEnclosedElements);
    }

    @Override
    public IRInnerClass get(IRClass.Res res) {
        String id = res.rName();
        IRInnerClass rInnerClass = this.rClass.get(id);
        if (rInnerClass != null) {
            return rInnerClass;
        }
        return RInnerClass.EMPTY_R_INNER_CLASS;
    }
}

