/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.googlecode.googleplus.GooglePlusFactory;
import com.googlecode.googleplus.Plus;
import com.googlecode.googleplus.impl.PeopleOperationsImpl;
import com.googlecode.googleplus.model.person.Person;
import com.googlecode.googleplus.model.person.PersonName;
import java.lang.reflect.Field;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class IntegrationTest {
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(8089);
    private ObjectMapper mapper = new ObjectMapper();

    @Test
    public void simpleIntegrationTest() throws Exception {
        this.pointToLocalhost();
        Person person = new Person();
        person.setId("1");
        person.setName(new PersonName());
        person.getName().setGivenName("Foo");
        person.getName().setFamilyName("Bar");
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)".+")).willReturn(WireMock.aResponse().withHeader("Content-Type", "application/json").withBody(this.mapper.writeValueAsString((Object)person))));
        GooglePlusFactory factory = new GooglePlusFactory("clientId", "secret");
        Plus plus = factory.getApi("access", "refresh", null);
        Person result = plus.getPeopleOperations().get("1");
        Assert.assertEquals((String)"IDs must match", (Object)person.getId(), (Object)result.getId());
        Assert.assertEquals((String)"Names must match", (Object)person.getName().getGivenName(), (Object)result.getName().getGivenName());
    }

    private void pointToLocalhost() throws NoSuchFieldException, IllegalAccessException {
        Field fld = PeopleOperationsImpl.class.getDeclaredField("GET_URL");
        this.setValue(fld, "http://localhost:8089/people/{id}");
    }

    private void setValue(Field fld, Object value) throws NoSuchFieldException, IllegalAccessException {
        fld.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(fld, fld.getModifiers() & 0xFFFFFFEF);
        fld.set(null, value);
    }
}

