/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus.impl;

import com.googlecode.googleplus.ActivityOperations;
import com.googlecode.googleplus.CommentOperations;
import com.googlecode.googleplus.GooglePlusConfiguration;
import com.googlecode.googleplus.MomentsOperations;
import com.googlecode.googleplus.PeopleOperations;
import com.googlecode.googleplus.Plus;
import com.googlecode.googleplus.core.OAuth2RefreshCallback;
import com.googlecode.googleplus.core.TokenRefreshingClientHttpRequestFactory;
import com.googlecode.googleplus.impl.ActivityOperationsImpl;
import com.googlecode.googleplus.impl.CommentOperationsImpl;
import com.googlecode.googleplus.impl.MomentsOperationsImpl;
import com.googlecode.googleplus.impl.PeopleOperationsImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class PlusImpl
extends AbstractOAuth2ApiBinding
implements Plus {
    private static boolean HTTP_COMPONENTS_AVAILABLE = ClassUtils.isPresent((String)"org.apache.http.client.HttpClient", (ClassLoader)ClientHttpRequestFactory.class.getClassLoader());
    private ActivityOperations activityOperations;
    private PeopleOperations peopleOperations;
    private CommentOperations commentOperations;
    private MomentsOperations historyOperations;
    private static final Field requestFactoryDelegateField = ReflectionUtils.findField(InterceptingClientHttpRequestFactory.class, (String)"requestFactory");

    public PlusImpl(String accessToken, GooglePlusConfiguration config, OAuth2RefreshCallback refreshCallback) {
        super(accessToken);
        this.configure(config);
        ClientHttpRequestFactory requestFactory = ClientHttpRequestFactorySelector.bufferRequests((ClientHttpRequestFactory)this.getRestTemplate().getRequestFactory());
        requestFactory = new TokenRefreshingClientHttpRequestFactory(requestFactory, refreshCallback, this.getRestTemplate().getInterceptors());
        this.getRestTemplate().setRequestFactory(requestFactory);
    }

    private void configure(GooglePlusConfiguration config) {
        ClientHttpRequestFactory clientRequestFactory = this.getRestTemplate().getRequestFactory();
        if (clientRequestFactory instanceof InterceptingClientHttpRequestFactory) {
            clientRequestFactory = (ClientHttpRequestFactory)ReflectionUtils.getField((Field)requestFactoryDelegateField, (Object)clientRequestFactory);
        }
        if (HTTP_COMPONENTS_AVAILABLE) {
            Method setter;
            if (config.getConnectTimeout() > 0) {
                setter = ReflectionUtils.findMethod(clientRequestFactory.getClass(), (String)"setConnectTimeout", (Class[])new Class[]{Integer.TYPE});
                setter.setAccessible(true);
                ReflectionUtils.invokeMethod((Method)setter, (Object)clientRequestFactory, (Object[])new Object[]{config.getReadTimeout()});
            }
            if (config.getReadTimeout() > 0) {
                setter = ReflectionUtils.findMethod(clientRequestFactory.getClass(), (String)"setReadTimeout", (Class[])new Class[]{Integer.TYPE});
                setter.setAccessible(true);
                ReflectionUtils.invokeMethod((Method)setter, (Object)clientRequestFactory, (Object[])new Object[]{config.getReadTimeout()});
            }
        } else {
            SimpleClientHttpRequestFactory factory = (SimpleClientHttpRequestFactory)clientRequestFactory;
            if (config.getConnectTimeout() > 0) {
                factory.setConnectTimeout(config.getConnectTimeout());
            }
            if (config.getReadTimeout() > 0) {
                factory.setReadTimeout(config.getReadTimeout());
            }
        }
    }

    public void init() {
        this.activityOperations = new ActivityOperationsImpl(this.getRestTemplate());
        this.peopleOperations = new PeopleOperationsImpl(this.getRestTemplate());
        this.commentOperations = new CommentOperationsImpl(this.getRestTemplate());
        this.historyOperations = new MomentsOperationsImpl(this.getRestTemplate());
    }

    public ActivityOperations getActivityOperations() {
        if (this.activityOperations == null) {
            throw new IllegalStateException("Call init() before using this object");
        }
        return this.activityOperations;
    }

    public PeopleOperations getPeopleOperations() {
        if (this.peopleOperations == null) {
            throw new IllegalStateException("Call init() before using this object");
        }
        return this.peopleOperations;
    }

    public CommentOperations getCommentOperations() {
        if (this.commentOperations == null) {
            throw new IllegalStateException("Call init() before using this object");
        }
        return this.commentOperations;
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.DRAFT_10;
    }

    public MomentsOperations getHistoryOperations() {
        if (this.historyOperations == null) {
            throw new IllegalStateException("Call init() before using this object");
        }
        return this.historyOperations;
    }

    static {
        requestFactoryDelegateField.setAccessible(true);
    }
}

