/*
 * Decompiled with CFR 0.152.
 */
package javaewah32;

import javaewah32.BitmapStorage32;
import javaewah32.BufferedRunningLengthWord32;
import javaewah32.EWAHCompressedBitmap32;
import javaewah32.EWAHIterator32;

public class IteratingBufferedRunningLengthWord32 {
    private int[] buffer;
    private int dirtyWordStartPosition;
    private BufferedRunningLengthWord32 brlw;
    private EWAHIterator32 iterator;

    public IteratingBufferedRunningLengthWord32(EWAHIterator32 iterator) {
        this.iterator = iterator;
        this.brlw = new BufferedRunningLengthWord32(this.iterator.next());
        this.dirtyWordStartPosition = this.iterator.dirtyWords() + this.brlw.dirtywordoffset;
        this.buffer = this.iterator.buffer();
    }

    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    public int getRunningLength() {
        return this.brlw.RunningLength;
    }

    public int size() {
        return this.brlw.size();
    }

    public int getDirtyWordAt(int index) {
        return this.buffer[this.dirtyWordStartPosition + index];
    }

    public void writeDirtyWords(int numWords, BitmapStorage32 container) {
        container.addStreamOfDirtyWords(this.buffer, this.dirtyWordStartPosition, numWords);
    }

    public void discardFirstWords(int x) {
        while (x > 0) {
            if (this.brlw.RunningLength >= x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0;
            int toDiscard = (x -= this.brlw.RunningLength) > this.brlw.NumberOfLiteralWords ? this.brlw.NumberOfLiteralWords : x;
            this.dirtyWordStartPosition += toDiscard;
            this.brlw.NumberOfLiteralWords -= toDiscard;
            if ((x -= toDiscard) <= 0 && this.brlw.size() != 0) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.dirtyWordStartPosition = this.iterator.dirtyWords() + this.brlw.dirtywordoffset;
        }
    }

    public void discharge(BitmapStorage32 container) {
        this.brlw.dirtywordoffset = this.dirtyWordStartPosition - this.iterator.dirtyWords();
        EWAHCompressedBitmap32.discharge(this.brlw, this.iterator, container);
    }
}

