/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.RunningLengthWord32;
import java.util.Stack;

final class ReverseEWAHIterator32 {
    private Stack<Integer> positions;
    private int pointer = 0;
    protected RunningLengthWord32 rlw;

    public ReverseEWAHIterator32(EWAHCompressedBitmap32 a, int sizeInWords) {
        this.rlw = new RunningLengthWord32(a, this.pointer);
        this.positions = new Stack();
        this.positions.ensureCapacity(sizeInWords);
        while (this.pointer < sizeInWords) {
            this.positions.push(this.pointer);
            this.rlw.position = this.pointer;
            this.pointer += this.rlw.getNumberOfLiteralWords() + 1;
        }
    }

    public int[] buffer() {
        return this.rlw.parent.buffer;
    }

    public int position() {
        return this.pointer;
    }

    public boolean hasPrevious() {
        return !this.positions.isEmpty();
    }

    public RunningLengthWord32 previous() {
        this.rlw.position = this.pointer = this.positions.pop().intValue();
        return this.rlw;
    }
}

