/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah.ChunkIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah32.BitCounter32;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.ChunkIteratorImpl32;
import com.googlecode.javaewah32.ClearIntIterator32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.FastAggregation32;
import com.googlecode.javaewah32.IntIteratorImpl32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.NonEmptyVirtualStorage32;
import com.googlecode.javaewah32.ReverseEWAHIterator32;
import com.googlecode.javaewah32.ReverseIntIterator32;
import com.googlecode.javaewah32.RunningLengthWord32;
import com.googlecode.javaewah32.symmetric.RunningBitmapMerge32;
import com.googlecode.javaewah32.symmetric.ThresholdFuncBitmap32;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class EWAHCompressedBitmap32
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage32,
LogicalElement<EWAHCompressedBitmap32> {
    int actualSizeInWords = 1;
    int[] buffer = null;
    RunningLengthWord32 rlw = null;
    int sizeInBits = 0;
    static final int DEFAULT_BUFFER_SIZE = 4;
    public static final boolean ADJUST_CONTAINER_SIZE_WHEN_AGGREGATING = true;
    public static final int WORD_IN_BITS = 32;
    static final long serialVersionUID = 1L;

    public EWAHCompressedBitmap32() {
        this.buffer = new int[4];
        this.rlw = new RunningLengthWord32(this, 0);
    }

    public EWAHCompressedBitmap32(int bufferSize) {
        if (bufferSize < 1) {
            bufferSize = 1;
        }
        this.buffer = new int[bufferSize];
        this.rlw = new RunningLengthWord32(this, 0);
    }

    @Deprecated
    public void add(int newData) {
        this.addWord(newData);
    }

    @Deprecated
    public void add(int newData, int bitsThatMatter) {
        this.addWord(newData, bitsThatMatter);
    }

    @Override
    public void addWord(int newData) {
        this.addWord(newData, 32);
    }

    public void addWord(int newData, int bitsThatMatter) {
        this.sizeInBits += bitsThatMatter;
        if (newData == 0) {
            this.insertEmptyWord(false);
        } else if (newData == -1) {
            this.insertEmptyWord(true);
        } else {
            this.insertLiteralWord(newData);
        }
    }

    private void insertEmptyWord(boolean v) {
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        int runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0) {
            this.rlw.setRunningBit(v);
        }
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 65535) {
            this.rlw.setRunningLength(runlen + 1);
            return;
        }
        this.push_back(0);
        this.rlw.position = this.actualSizeInWords - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1);
    }

    @Override
    public void addLiteralWord(int newData) {
        this.sizeInBits += 32;
        this.insertLiteralWord(newData);
    }

    private void insertLiteralWord(int newData) {
        int numbersofar = this.rlw.getNumberOfLiteralWords();
        if (numbersofar >= Short.MAX_VALUE) {
            this.push_back(0);
            this.rlw.position = this.actualSizeInWords - 1;
            this.rlw.setNumberOfLiteralWords(1);
            this.push_back(newData);
            return;
        }
        this.rlw.setNumberOfLiteralWords(numbersofar + 1);
        this.push_back(newData);
    }

    @Override
    public void addStreamOfLiteralWords(int[] data, int start, int number) {
        int leftovernumber = number;
        while (leftovernumber > 0) {
            int numberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatWeCanAdd = leftovernumber < Short.MAX_VALUE - numberOfLiteralWords ? leftovernumber : Short.MAX_VALUE - numberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(numberOfLiteralWords + whatWeCanAdd);
            this.push_back(data, start, whatWeCanAdd);
            this.sizeInBits += whatWeCanAdd * 32;
            if ((leftovernumber -= whatWeCanAdd) <= 0) continue;
            this.push_back(0);
            this.rlw.position = this.actualSizeInWords - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, int number) {
        if (number == 0) {
            return;
        }
        this.sizeInBits += number * 32;
        this.fastaddStreamOfEmptyWords(v, number);
    }

    @Override
    public void addStreamOfNegatedLiteralWords(int[] data, int start, int number) {
        int leftovernumber = number;
        while (leftovernumber > 0) {
            int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatwecanadd = leftovernumber < Short.MAX_VALUE - NumberOfLiteralWords ? leftovernumber : Short.MAX_VALUE - NumberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
            this.negative_push_back(data, start, whatwecanadd);
            this.sizeInBits += whatwecanadd * 32;
            if ((leftovernumber -= whatwecanadd) <= 0) continue;
            this.push_back(0);
            this.rlw.position = this.actualSizeInWords - 1;
        }
    }

    @Override
    public EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 a) {
        int size = this.actualSizeInWords > a.actualSizeInWords ? this.actualSizeInWords : a.actualSizeInWords;
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32(size);
        this.andToContainer(a, container);
        return container;
    }

    public void andToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        container.clear();
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    int index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addLiteralWord(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.dischargeAsEmpty(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.andToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap32 andNot(EWAHCompressedBitmap32 a) {
        int size = this.actualSizeInWords > a.actualSizeInWords ? this.actualSizeInWords : a.actualSizeInWords;
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32(size);
        this.andNotToContainer(a, container);
        return container;
    }

    public void andNotToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        IteratingBufferedRunningLengthWord32 remaining;
        container.clear();
        EWAHIterator32 i = this.getEWAHIterator();
        EWAHIterator32 j = a.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index;
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else if (i_is_prey) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                } else {
                    index = prey.dischargeNegated(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addLiteralWord(rlwi.getLiteralWordAt(k) & ~rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        } else {
            remaining.dischargeAsEmpty(container);
        }
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.andNotToContainer(a, counter);
        return counter.getCount();
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator32 i = this.getEWAHIterator();
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter += 32 * localrlw.getRunningLength();
            }
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                counter += Integer.bitCount(i.buffer()[i.literalWords() + j]);
            }
        }
        return counter;
    }

    @Override
    public void clear() {
        this.sizeInBits = 0;
        this.actualSizeInWords = 1;
        this.rlw.position = 0;
        this.buffer[0] = 0;
    }

    public EWAHCompressedBitmap32 clone() {
        EWAHCompressedBitmap32 clone = null;
        try {
            clone = (EWAHCompressedBitmap32)super.clone();
            clone.buffer = (int[])this.buffer.clone();
            clone.actualSizeInWords = this.actualSizeInWords;
            clone.sizeInBits = this.sizeInBits;
            clone.rlw = new RunningLengthWord32(clone, this.rlw.position);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeInBits = in.readInt();
        this.actualSizeInWords = in.readInt();
        if (this.buffer.length < this.actualSizeInWords) {
            this.buffer = new int[this.actualSizeInWords];
        }
        for (int k = 0; k < this.actualSizeInWords; ++k) {
            this.buffer[k] = in.readInt();
        }
        this.rlw = new RunningLengthWord32(this, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap32) {
            try {
                this.xorToContainer((EWAHCompressedBitmap32)o, new NonEmptyVirtualStorage32());
                return true;
            }
            catch (NonEmptyVirtualStorage32.NonEmptyException e) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, int number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0);
            this.rlw.position = this.actualSizeInWords - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
        }
        int runLen = this.rlw.getRunningLength();
        int whatWeCanAdd = number < 65535 - runLen ? number : 65535 - runLen;
        this.rlw.setRunningLength(runLen + whatWeCanAdd);
        number -= whatWeCanAdd;
        while (number >= 65535) {
            this.push_back(0);
            this.rlw.position = this.actualSizeInWords - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(65535);
            number -= 65535;
        }
        if (number > 0) {
            this.push_back(0);
            this.rlw.position = this.actualSizeInWords - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(number);
        }
    }

    public EWAHIterator32 getEWAHIterator() {
        return new EWAHIterator32(this, this.actualSizeInWords);
    }

    private ReverseEWAHIterator32 getReverseEWAHIterator() {
        return new ReverseEWAHIterator32(this, this.actualSizeInWords);
    }

    public IteratingRLW32 getIteratingRLW() {
        return new IteratingBufferedRunningLengthWord32(this);
    }

    @Deprecated
    public List<Integer> getPositions() {
        return this.toList();
    }

    public List<Integer> toList() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator32 i = this.getEWAHIterator();
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                for (j = 0; j < localrlw.getRunningLength(); ++j) {
                    for (int c = 0; c < 32; ++c) {
                        v.add(pos++);
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int T;
                for (int data = i.buffer()[i.literalWords() + j]; data != 0; data ^= T) {
                    T = data & -data;
                    v.add(Integer.bitCount(T - 1) + pos);
                }
                pos += 32;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeInBits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = 31;
        EWAHIterator32 i = this.getEWAHIterator();
        while (i.hasNext()) {
            i.next();
            if (i.rlw.getRunningBit()) {
                karprabin += 31 * karprabin + i.rlw.getRunningLength();
            }
            for (int k = 0; k < i.rlw.getNumberOfLiteralWords(); ++k) {
                karprabin += 31 * karprabin + this.buffer[k + i.literalWords()];
            }
        }
        return karprabin;
    }

    public boolean intersects(EWAHCompressedBitmap32 a) {
        NonEmptyVirtualStorage32 nevs = new NonEmptyVirtualStorage32();
        try {
            this.andToContainer(a, nevs);
        }
        catch (NonEmptyVirtualStorage32.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl32(this.getEWAHIterator());
    }

    public IntIterator reverseIntIterator() {
        return new ReverseIntIterator32(this.getReverseEWAHIterator(), this.sizeInBits);
    }

    public boolean isEmpty() {
        return this.getFirstSetBit() < 0;
    }

    public IntIterator clearIntIterator() {
        return new ClearIntIterator32(this.getEWAHIterator(), this.sizeInBits);
    }

    public ChunkIterator chunkIterator() {
        return new ChunkIteratorImpl32(this.getEWAHIterator(), this.sizeInBits);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap32.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    private void negative_push_back(int[] data, int start, int number) {
        int size = this.newSizeInWords(number);
        if (size >= this.buffer.length) {
            int[] oldBuffer = this.buffer;
            this.buffer = new int[size];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        for (int k = 0; k < number; ++k) {
            this.buffer[this.actualSizeInWords + k] = ~data[start + k];
        }
        this.actualSizeInWords += number;
    }

    @Override
    public void not() {
        RunningLengthWord32 rlw1;
        EWAHIterator32 i = this.getEWAHIterator();
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            for (int j = 0; j < rlw1.getNumberOfLiteralWords(); ++j) {
                i.buffer()[i.literalWords() + j] = ~i.buffer()[i.literalWords() + j];
            }
        } while (i.hasNext());
        int usedbitsinlast = this.sizeInBits % 32;
        if (usedbitsinlast == 0) {
            return;
        }
        if (rlw1.getNumberOfLiteralWords() == 0) {
            if (rlw1.getRunningLength() > 0 && rlw1.getRunningBit()) {
                if (rlw1.getRunningLength() == 1 && rlw1.position > 0) {
                    EWAHIterator32 j = this.getEWAHIterator();
                    int newrlwpos = this.rlw.position;
                    while (j.hasNext()) {
                        RunningLengthWord32 r = j.next();
                        if (r.position >= rlw1.position) break;
                        newrlwpos = r.position;
                    }
                    this.rlw.position = newrlwpos;
                    --this.actualSizeInWords;
                } else {
                    rlw1.setRunningLength(rlw1.getRunningLength() - 1);
                }
                this.insertLiteralWord(-1 >>> 32 - usedbitsinlast);
            }
            return;
        }
        int[] nArray = i.buffer();
        int n = i.literalWords() + rlw1.getNumberOfLiteralWords() - 1;
        nArray[n] = nArray[n] & -1 >>> 32 - usedbitsinlast;
    }

    @Override
    public EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualSizeInWords + a.actualSizeInWords);
        this.orToContainer(a, container);
        return container;
    }

    public void orToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        container.clear();
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingBufferedRunningLengthWord32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 iteratingBufferedRunningLengthWord32 = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    int index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addLiteralWord(rlwi.getLiteralWordAt(k) | rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        if (rlwj.size() > 0 && rlwi.size() > 0) {
            throw new RuntimeException("fds");
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.orToContainer(a, counter);
        return counter.getCount();
    }

    private void push_back(int data) {
        int size = this.newSizeInWords(1);
        if (size >= this.buffer.length) {
            int[] oldBuffer = this.buffer;
            this.buffer = new int[size];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        this.buffer[this.actualSizeInWords++] = data;
    }

    private void push_back(int[] data, int start, int number) {
        int size = this.newSizeInWords(number);
        if (size >= this.buffer.length) {
            int[] oldBuffer = this.buffer;
            this.buffer = new int[size];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
            this.rlw.parent.buffer = this.buffer;
        }
        System.arraycopy(data, start, this.buffer, this.actualSizeInWords, number);
        this.actualSizeInWords += number;
    }

    private int newSizeInWords(int number) {
        int size = this.actualSizeInWords + number;
        if (size >= this.buffer.length) {
            size = size < 32768 ? (size *= 2) : (size * 3 / 2 < size ? Integer.MAX_VALUE : size * 3 / 2);
        }
        return size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    private boolean reserve(int size) {
        if (size > this.buffer.length) {
            int[] oldBuffer = this.buffer;
            this.buffer = new int[size];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
            this.rlw.parent.buffer = this.buffer;
            return true;
        }
        return false;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeInBits);
        out.writeInt(this.actualSizeInWords);
        for (int k = 0; k < this.actualSizeInWords; ++k) {
            out.writeInt(this.buffer[k]);
        }
        out.writeInt(this.rlw.position);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean get(int i) {
        if (i < 0 || i >= this.sizeInBits) {
            return false;
        }
        IteratingRLW32 j = this.getIteratingRLW();
        int wordi = i / 32;
        for (int wordChecked = 0; wordChecked <= wordi; wordChecked += j.getNumberOfLiteralWords()) {
            if (wordi < (wordChecked += j.getRunningLength())) {
                return j.getRunningBit();
            }
            if (wordi < wordChecked + j.getNumberOfLiteralWords()) {
                int w = j.getLiteralWordAt(wordi - wordChecked);
                return (w & 1 << i) != 0;
            }
            j.next();
        }
        return false;
    }

    public int getFirstSetBit() {
        int nword = 0;
        for (int pos = 0; pos < this.actualSizeInWords; ++pos) {
            int word;
            int rl = RunningLengthWord32.getRunningLength(this.buffer, pos);
            boolean rb = RunningLengthWord32.getRunningBit(this.buffer, pos);
            if (rl > 0 && rb) {
                return nword * 32;
            }
            nword += rl;
            int lw = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, pos);
            if (lw <= 0 || (word = this.buffer[pos + 1]) == 0) continue;
            int T = word & -word;
            return nword * 32 + Integer.bitCount(T - 1);
        }
        return -1;
    }

    public boolean set(int i) {
        if (i > 0x7FFFFFDF || i < 0) {
            throw new IndexOutOfBoundsException("Set values should be between 0 and 2147483615");
        }
        if (i < this.sizeInBits) {
            this.locateAndSet(i);
        } else {
            this.extendAndSet(i);
        }
        return true;
    }

    private void extendAndSet(int i) {
        int dist = this.distanceInWords(i);
        this.sizeInBits = i + 1;
        if (dist > 0) {
            if (dist > 1) {
                this.fastaddStreamOfEmptyWords(false, dist - 1);
            }
            this.insertLiteralWord(1 << i % 32);
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
            this.insertLiteralWord(1 << i % 32);
        }
        int n = this.actualSizeInWords - 1;
        this.buffer[n] = this.buffer[n] | 1 << i % 32;
        if (this.buffer[this.actualSizeInWords - 1] == -1) {
            this.buffer[this.actualSizeInWords - 1] = 0;
            --this.actualSizeInWords;
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            this.insertEmptyWord(true);
        }
    }

    private void locateAndSet(int i) {
        int lw;
        int nbits = 0;
        for (int pos = 0; pos < this.actualSizeInWords; pos += lw + 1) {
            int rl = RunningLengthWord32.getRunningLength(this.buffer, pos);
            boolean rb = RunningLengthWord32.getRunningBit(this.buffer, pos);
            lw = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, pos);
            int rbits = rl * 32;
            if (i < nbits + rbits) {
                this.setInRunningLength(i, nbits, pos, rl, rb, lw);
                return;
            }
            int lbits = lw * 32;
            if (i < (nbits += rbits) + lbits) {
                this.setInLiteralWords(i, nbits, pos, rl, rb, lw);
                return;
            }
            nbits += lbits;
        }
    }

    private void setInRunningLength(int i, int nbits, int pos, int rl, boolean rb, int lw) {
        if (!rb) {
            int wordPosition = (i - nbits) / 32 + 1;
            int addedWords = wordPosition == rl ? 1 : 2;
            int size = this.newSizeInWords(addedWords);
            int[] oldBuffer = this.buffer;
            if (size >= this.buffer.length) {
                this.buffer = new int[size];
                System.arraycopy(oldBuffer, 0, this.buffer, 0, pos + 1);
            }
            System.arraycopy(oldBuffer, pos + 1, this.buffer, pos + 1 + addedWords, this.actualSizeInWords - pos - 1);
            this.actualSizeInWords += addedWords;
            this.buffer[pos + 1] = 1 << i % 32;
            if (this.rlw.position >= pos + 1) {
                this.rlw.position += addedWords;
            }
            if (addedWords == 1) {
                this.setRLWInfo(pos, false, rl - 1, lw + 1);
            } else {
                this.setRLWInfo(pos, false, wordPosition - 1, 1);
                this.setRLWInfo(pos + 2, false, rl - wordPosition, lw);
                if (this.rlw.position == pos) {
                    this.rlw.position += 2;
                }
            }
        }
    }

    private void setInLiteralWords(int i, int nbits, int pos, int rl, boolean rb, int lw) {
        int wordPosition = (i - nbits) / 32 + 1;
        int n = pos + wordPosition;
        this.buffer[n] = this.buffer[n] | 1 << i % 32;
        if (this.buffer[pos + wordPosition] == -1) {
            boolean canMergeInCurrentRLW = this.mergeLiteralWordInCurrentRunningLength(rb, rl, wordPosition);
            boolean canMergeInNextRLW = this.mergeLiteralWordInNextRunningLength(lw, pos, wordPosition);
            if (canMergeInCurrentRLW && canMergeInNextRLW) {
                int nextRl = RunningLengthWord32.getRunningLength(this.buffer, pos + 2);
                int nextLw = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, pos + 2);
                System.arraycopy(this.buffer, pos + 2, this.buffer, pos, this.actualSizeInWords - pos - 2);
                this.buffer[--this.actualSizeInWords] = 0;
                this.buffer[--this.actualSizeInWords] = 0;
                this.setRLWInfo(pos, true, rl + 1 + nextRl, nextLw);
                if (this.rlw.position >= pos + 2) {
                    this.rlw.position -= 2;
                }
            } else if (canMergeInCurrentRLW) {
                System.arraycopy(this.buffer, pos + 2, this.buffer, pos + 1, this.actualSizeInWords - pos - 2);
                this.buffer[--this.actualSizeInWords] = 0;
                this.setRLWInfo(pos, true, rl + 1, lw - 1);
                if (this.rlw.position >= pos + 2) {
                    --this.rlw.position;
                }
            } else if (canMergeInNextRLW) {
                int nextRLWPos = pos + lw + 1;
                int nextRl = RunningLengthWord32.getRunningLength(this.buffer, nextRLWPos);
                int nextLw = RunningLengthWord32.getNumberOfLiteralWords(this.buffer, nextRLWPos);
                System.arraycopy(this.buffer, nextRLWPos, this.buffer, pos + wordPosition, this.actualSizeInWords - nextRLWPos);
                this.buffer[--this.actualSizeInWords] = 0;
                this.setRLWInfo(pos, rb, rl, lw - 1);
                this.setRLWInfo(pos + wordPosition, true, nextRl + 1, nextLw);
                if (this.rlw.position >= nextRLWPos) {
                    this.rlw.position -= lw + 1 - wordPosition;
                }
            } else {
                this.setRLWInfo(pos, rb, rl, wordPosition - 1);
                this.setRLWInfo(pos + wordPosition, true, 1, lw - wordPosition);
                if (this.rlw.position == pos) {
                    this.rlw.position += wordPosition;
                }
            }
        }
    }

    private boolean mergeLiteralWordInCurrentRunningLength(boolean rb, int rl, int wordPosition) {
        return (rb || rl == 0) && wordPosition == 1;
    }

    private boolean mergeLiteralWordInNextRunningLength(int lw, int pos, int wordPosition) {
        int nextRLWPos = pos + lw + 1;
        if (lw == wordPosition && nextRLWPos < this.actualSizeInWords) {
            int nextRl = RunningLengthWord32.getRunningLength(this.buffer, nextRLWPos);
            boolean nextRb = RunningLengthWord32.getRunningBit(this.buffer, nextRLWPos);
            return nextRb || nextRl == 0;
        }
        return false;
    }

    private void setRLWInfo(int pos, boolean rb, int rl, int lw) {
        RunningLengthWord32.setRunningBit(this.buffer, pos, rb);
        RunningLengthWord32.setRunningLength(this.buffer, pos, rl);
        RunningLengthWord32.setNumberOfLiteralWords(this.buffer, pos, lw);
    }

    @Override
    public void setSizeInBitsWithinLastWord(int size) {
        if ((size + 32 - 1) / 32 != (this.sizeInBits + 32 - 1) / 32) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInbits(int,boolean): " + size + " " + this.sizeInBits);
        }
        this.sizeInBits = size;
        int usedBitsInLast = this.sizeInBits % 32;
        if (usedBitsInLast == 0) {
            return;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            if (this.rlw.getRunningLength() > 0 && this.rlw.getRunningBit()) {
                if (this.rlw.getRunningLength() == 1 && this.rlw.position > 0) {
                    EWAHIterator32 j = this.getEWAHIterator();
                    int newrlwpos = this.rlw.position;
                    while (j.hasNext()) {
                        RunningLengthWord32 r = j.next();
                        if (r.position >= this.rlw.position) break;
                        newrlwpos = r.position;
                    }
                    this.rlw.position = newrlwpos;
                    --this.actualSizeInWords;
                } else {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
                }
                this.insertLiteralWord(-1 >>> 32 - usedBitsInLast);
            }
            return;
        }
        int n = this.actualSizeInWords - 1;
        this.buffer[n] = this.buffer[n] & -1 >>> 32 - usedBitsInLast;
    }

    public boolean setSizeInBits(int size, boolean defaultValue) {
        if (size <= this.sizeInBits) {
            return false;
        }
        if (this.sizeInBits % 32 != 0) {
            if (!defaultValue) {
                if (this.rlw.getNumberOfLiteralWords() > 0) {
                    int bitsToAdd = size - this.sizeInBits;
                    int usedBitsInLast = this.sizeInBits % 32;
                    int freeBitsInLast = 32 - usedBitsInLast;
                    if (this.buffer[this.actualSizeInWords - 1] == 0) {
                        this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                        --this.actualSizeInWords;
                        this.sizeInBits -= usedBitsInLast;
                    } else if (usedBitsInLast > 0) {
                        this.sizeInBits += Math.min(bitsToAdd, freeBitsInLast);
                    }
                }
            } else {
                if (this.rlw.getNumberOfLiteralWords() == 0) {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1);
                    this.insertLiteralWord(0);
                }
                int maskWidth = Math.min(32 - this.sizeInBits % 32, size - this.sizeInBits);
                int maskShift = this.sizeInBits % 32;
                int n = this.actualSizeInWords - 1;
                this.buffer[n] = this.buffer[n] | -1 >>> 32 - maskWidth << maskShift;
                if (this.buffer[this.actualSizeInWords - 1] == -1) {
                    this.buffer[this.actualSizeInWords - 1] = 0;
                    --this.actualSizeInWords;
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(true);
                }
                this.sizeInBits += maskWidth;
            }
        }
        this.addStreamOfEmptyWords(defaultValue, size / 32 - this.sizeInBits / 32);
        if (this.sizeInBits < size) {
            int dist = this.distanceInWords(size - 1);
            if (dist > 0) {
                this.addLiteralWord(0);
            }
            if (defaultValue) {
                int maskWidth = size - this.sizeInBits;
                int maskShift = this.sizeInBits % 32;
                int n = this.actualSizeInWords - 1;
                this.buffer[n] = this.buffer[n] | -1 >>> 32 - maskWidth << maskShift;
            }
            this.sizeInBits = size;
        }
        return true;
    }

    private int distanceInWords(int i) {
        return (i + 32) / 32 - (this.sizeInBits + 32 - 1) / 32;
    }

    @Override
    public int sizeInBits() {
        return this.sizeInBits;
    }

    @Override
    public int sizeInBytes() {
        return this.actualSizeInWords * 4;
    }

    public static EWAHCompressedBitmap32 threshold(int t, EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        EWAHCompressedBitmap32.thresholdWithContainer(container, t, bitmaps);
        return container;
    }

    public static void thresholdWithContainer(BitmapStorage32 container, int t, EWAHCompressedBitmap32 ... bitmaps) {
        new RunningBitmapMerge32().symmetric(new ThresholdFuncBitmap32(t), container, bitmaps);
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inanspos = 0;
        int pos = 0;
        EWAHIterator32 i = this.getEWAHIterator();
        while (i.hasNext()) {
            int j;
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                for (j = 0; j < localrlw.getRunningLength(); ++j) {
                    for (int c = 0; c < 32; ++c) {
                        ans[inanspos++] = pos++;
                    }
                }
            } else {
                pos += 32 * localrlw.getRunningLength();
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int t;
                for (int data = i.buffer()[i.literalWords() + j]; data != 0; data ^= t) {
                    t = data & -data;
                    ans[inanspos++] = Integer.bitCount(t - 1) + pos;
                }
                pos += 32;
            }
        }
        return ans;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer(" EWAHCompressedBitmap, size in bits = ");
        sb.append(this.sizeInBits).append(" size in words = ");
        sb.append(this.actualSizeInWords).append("\n");
        EWAHIterator32 i = this.getEWAHIterator();
        while (i.hasNext()) {
            RunningLengthWord32 localrlw = i.next();
            if (localrlw.getRunningBit()) {
                sb.append(localrlw.getRunningLength()).append(" 1x11\n");
            } else {
                sb.append(localrlw.getRunningLength()).append(" 0x00\n");
            }
            sb.append(localrlw.getNumberOfLiteralWords()).append(" dirties\n");
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int data = i.buffer()[i.literalWords() + j];
                sb.append("\t").append(data).append("\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.intIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void swap(EWAHCompressedBitmap32 other) {
        int[] tmp = this.buffer;
        this.buffer = other.buffer;
        other.buffer = tmp;
        int tmp2 = this.rlw.position;
        this.rlw.position = other.rlw.position;
        other.rlw.position = tmp2;
        int tmp3 = this.actualSizeInWords;
        this.actualSizeInWords = other.actualSizeInWords;
        other.actualSizeInWords = tmp3;
        int tmp4 = this.sizeInBits;
        this.sizeInBits = other.sizeInBits;
        other.sizeInBits = tmp4;
    }

    public void trim() {
        this.buffer = Arrays.copyOf(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 a) {
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        container.reserve(this.actualSizeInWords + a.actualSizeInWords);
        this.xorToContainer(a, container);
        return container;
    }

    public void xorToContainer(EWAHCompressedBitmap32 a, BitmapStorage32 container) {
        container.clear();
        EWAHIterator32 i = a.getEWAHIterator();
        EWAHIterator32 j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord32 rlwi = new IteratingBufferedRunningLengthWord32(i);
        IteratingBufferedRunningLengthWord32 rlwj = new IteratingBufferedRunningLengthWord32(j);
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord32 prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord32 predator = i_is_prey ? rlwj : rlwi;
                int index = !predator.getRunningBit() ? prey.discharge(container, predator.getRunningLength()) : prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(predator.getRunningBit(), predator.getRunningLength() - index);
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addLiteralWord(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0;
        IteratingBufferedRunningLengthWord32 remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap32 a) {
        BitCounter32 counter = new BitCounter32();
        this.xorToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap32 compose(EWAHCompressedBitmap32 a) {
        int size = this.actualSizeInWords;
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32(size);
        this.composeToContainer(a, container);
        return container;
    }

    public void composeToContainer(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 container) {
        container.clear();
        ChunkIterator iterator = this.chunkIterator();
        ChunkIterator aIterator = a.chunkIterator();
        int index = 0;
        while (iterator.hasNext() && aIterator.hasNext()) {
            int length;
            if (!iterator.nextBit()) {
                length = iterator.nextLength();
                container.setSizeInBits(index += length, false);
                iterator.move(length);
                continue;
            }
            length = Math.min(iterator.nextLength(), aIterator.nextLength());
            container.setSizeInBits(index += length, aIterator.nextBit());
            iterator.move(length);
            aIterator.move(length);
        }
        container.setSizeInBits(this.sizeInBits, false);
    }

    public static void andWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            throw new IllegalArgumentException("Need at least one bitmap");
        }
        if (bitmaps.length == 2) {
            bitmaps[0].andToContainer(bitmaps[1], container);
            return;
        }
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        EWAHCompressedBitmap32 tmp = new EWAHCompressedBitmap32();
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length - 1; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        answer.andToContainer(bitmaps[bitmaps.length - 1], container);
    }

    public static EWAHCompressedBitmap32 and(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].and(bitmaps[1]);
        }
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        EWAHCompressedBitmap32 tmp = new EWAHCompressedBitmap32();
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        return answer;
    }

    public static int andCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.andWithContainer(counter, bitmaps);
        return counter.getCount();
    }

    public static EWAHCompressedBitmap32 bitmapOf(int ... setbits) {
        EWAHCompressedBitmap32 a = new EWAHCompressedBitmap32();
        for (int k : setbits) {
            a.set(k);
        }
        return a;
    }

    public static void orWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        int size = 0;
        int sinbits = 0;
        for (EWAHCompressedBitmap32 b : bitmaps) {
            size += b.sizeInBytes();
            if (sinbits >= b.sizeInBits()) continue;
            sinbits = b.sizeInBits();
        }
        if (size * 8 > sinbits) {
            FastAggregation32.bufferedorWithContainer(container, 65536, bitmaps);
        } else {
            FastAggregation32.orToContainer(container, bitmaps);
        }
    }

    public static void xorWithContainer(BitmapStorage32 container, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        int size = 0;
        int sinbits = 0;
        for (EWAHCompressedBitmap32 b : bitmaps) {
            size += b.sizeInBytes();
            if (sinbits >= b.sizeInBits()) continue;
            sinbits = b.sizeInBits();
        }
        if (size * 8 > sinbits) {
            FastAggregation32.bufferedxorWithContainer(container, 65536, bitmaps);
        } else {
            FastAggregation32.xorToContainer(container, bitmaps);
        }
    }

    public static EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        int largestSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualSizeInWords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap32.orWithContainer(container, bitmaps);
        return container;
    }

    public static EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        EWAHCompressedBitmap32 container = new EWAHCompressedBitmap32();
        int largestSize = 0;
        for (EWAHCompressedBitmap32 bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualSizeInWords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap32.xorWithContainer(container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter32 counter = new BitCounter32();
        EWAHCompressedBitmap32.orWithContainer(counter, bitmaps);
        return counter.getCount();
    }
}

