/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.maven;

import com.google.gdata.client.Query;
import com.google.gdata.client.projecthosting.IssuesQuery;
import com.google.gdata.client.projecthosting.ProjectHostingService;
import com.google.gdata.data.projecthosting.IssuesEntry;
import com.google.gdata.data.projecthosting.IssuesFeed;
import com.google.gdata.data.projecthosting.Label;
import com.google.gdata.data.projecthosting.State;
import com.googlecode.maven.Changes;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateReportMojo
extends AbstractMojo {
    private static final String TYPE_LABEL = "Type-";
    private static final String MILESTONE_LABEL = "Milestone-";
    private static final String ALL_MILESTONES = "all";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private String username;
    private String password;
    private String projectIdentifier;
    private String milestone;
    private File xmlPath;
    private Map<String, String> issueTypes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ProjectHostingService service = new ProjectHostingService("maven-changes-1");
            if (this.username != null) {
                service.setUserCredentials(this.username, this.password);
            }
            URL feedUrl = new URL("http://code.google.com/feeds/issues/p/" + this.projectIdentifier + "/issues/full");
            IssuesQuery query = new IssuesQuery(feedUrl);
            query.setLabel("Milestone-1_0_RC");
            query.setMaxResults(Integer.MAX_VALUE);
            IssuesFeed issues = (IssuesFeed)service.getFeed((Query)query, IssuesFeed.class);
            Release release = new Release();
            if (!this.milestone.equals(ALL_MILESTONES)) {
                release.setVersion(this.milestone);
            }
            release.setDescription("");
            release.setDateRelease(DATE_FORMAT.format(new Date()));
            LinkedList<Action> actions = new LinkedList<Action>();
            for (IssuesEntry issue : issues.getEntries()) {
                String issueType;
                if (!State.Value.CLOSED.equals((Object)issue.getState().getValue())) continue;
                Action action = new Action();
                if (issue.getOwner() != null) {
                    action.setDev(issue.getOwner().getUsername().getValue());
                }
                if (!this.issueTypes.containsKey(issueType = this.extractNamedLabel(issue.getLabels(), TYPE_LABEL))) {
                    this.getLog().warn((CharSequence)("Type <" + issueType + "> cannot be translated for issue <" + issue.getIssueId() + ">; skipping"));
                    continue;
                }
                action.setType(this.issueTypes.get(issueType));
                action.setIssue(issue.getVersionId());
                action.setAction(issue.getIssueId().getValue() + ": " + issue.getTitle().getPlainText());
                actions.add(action);
            }
            release.setActions(actions);
            Changes.generate(release, this.xmlPath, this.getLog());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private String extractNamedLabel(List<Label> labels, String name) {
        for (Label label : labels) {
            String labelName = label.getValue();
            if (!labelName.startsWith(name)) continue;
            return labelName.substring(name.length());
        }
        return null;
    }
}

